import React from 'react';

import { Window } from '../../../../ui/FullModal';
import { Input } from '../../../../ui/Input';
import { FeatureBlock } from './FeatureBlock';
import style from './index.css';

interface IUserFeaturesModalProps {
    onClose: () => void;
    factorsArray: Record<string, string | number>;
    categoriesArray: Record<string, string | number>;
}

export const UserFeaturesModal = (props: IUserFeaturesModalProps) => {
    const { onClose, factorsArray, categoriesArray } = props;
    const [filterValue, setInputValue] = React.useState<string>('');

    const onChange = (value) => {
        setInputValue(value);
    };

    return (
        <Window title={'Список фичей пользователя'} onClose={onClose}>
            <Input value={filterValue}
                   onChange={onChange}
                   placeholder={'Фильтр'}/>

            <div className={style.container}>
                <FeatureBlock title={'Факторы'}
                              data={factorsArray}
                              filterValue={filterValue}/>
                <FeatureBlock title={'Категории'}
                              data={categoriesArray}
                              filterValue={filterValue}/>
            </div>
        </Window>
    );
};
