import React from 'react';

import { EMPTY_DATA } from '../../../constants';
import { useRequestHandler } from '../../../hooks/useRequestHandler';
import { Button, ButtonTypes } from '../../../ui/Button';
import { ShortError } from '../../../ui/ErrorBar';
import { IBlockRules } from '../../../utils/IBlockRules';
import { Request2 } from '../../../utils/request';
import { CLIENTS_CARD_REQUESTS, REQUESTS } from '../request';
import style from './index.css';
import { UserFeaturesModal } from './UserFeaturesModal';

interface IUserFeaturesBlockProps extends IBlockRules {
    user_id: string;
}

export const UserFeaturesBlock = (props: IUserFeaturesBlockProps) => {
    const { user_id, BlockRules } = props;
    const [isModalOpen, setIsModalOpen] = React.useState(false);
    const [factorsArray, setFactorsArray] = React.useState<Record<string, string | number> | null>(null);
    const [categoriesArray, setCategoriesArray] = React.useState<Record<string, string | number> | null>(null);

    const request = new Request2({ requestConfigs: CLIENTS_CARD_REQUESTS });
    const requestOptions = React.useMemo(() => {
        return {
            requestName: REQUESTS.GET_USER_FEATURES,
            requestOptions: {
                queryParams: {
                    user_id,
                },
            },
        };
    }, [user_id]);

    const responseHandler = (response) => {
        setFactorsArray(response?.features?.factors);
        setCategoriesArray(response?.features?.cat_factors);

        return response;
    };

    const [
        isLoading, ,
        error,
        makeResponse,
    ] = useRequestHandler<Record<string, string | number>>(request, requestOptions, responseHandler);

    React.useEffect(() => {
        BlockRules?.ShowUserFeatures && user_id && makeResponse();
    }, []);

    return <>
        {error
            ? <ShortError error={error}/>
            : BlockRules?.ShowUserFeatures
                ? <div>
                    <Button colorType={ButtonTypes.positive}
                            onClick={() => setIsModalOpen(true)}
                            isLoading={isLoading}
                            className={style.button}>
                        Фичи пользователя
                    </Button>

                    {categoriesArray
                        ? <div className={style.fav_feats}>
                            <div>
                                <b>Долг. скоринг:</b> {factorsArray?.PmUserDebtScore28d ?? EMPTY_DATA}
                            </div>

                            <div>
                                <b>Всего потрачено:</b> {factorsArray?.PmRubPaid ?? EMPTY_DATA}
                            </div>
                        </div>
                        : null
                    }

                    {isModalOpen
                        ? <UserFeaturesModal onClose={setIsModalOpen.bind(null, false)}
                                             categoriesArray={categoriesArray ?? {}}
                                             factorsArray={factorsArray ?? {}}/>
                        : null
                    }
                </div>
                : null
        }
    </>;
};
