import React, { useState } from 'react';

import { UserInfoHandler } from '../../../models/user';
import { ShortError } from '../../../ui/ErrorBar';
import FormatDate from '../../../ui/FormatDate';
import { Link } from '../../../ui/Link';
import { Request2 } from '../../../utils/request';
import { buttonLocationDetails, buttonNameDetails } from '../../../utils/sendLogs/eventTypes/buttonDetails';
import { Copy } from '../../Copy';
import Spin from '../../Spin';
import { CORE_USER_INFO_REQUESTS as requestConfigs, REQUESTS } from '../UserInfoView/request';
import { IMapStateToProps } from './index';
import * as style from './index.css';

interface IUserIdentificationBlockProps extends IMapStateToProps {
    user_id?: string;
}

export const UserIdentificationBlock = (props: IUserIdentificationBlockProps) => {
    const [isInfoShown, showInfo] = useState(false);
    const [nameInfo, setNameInfo] = useState({});
    const [isDataLoading, setIsDataLoading] = useState(false);
    const [error, setError] = useState(null);
    const [userInfo, setUserInfo] = useState({});
    const { user_id, BlockRules } = props;
    const ytLogData = {
        button_name: buttonNameDetails.IDENTIFY_USER,
        user_id,
        location: buttonLocationDetails.CLIENT_CARD,
    };

    const request = new Request2({ requestConfigs });

    function getUserInfo() {
        if (!isInfoShown) {
            setIsDataLoading(true);
            request.exec(REQUESTS.GET_FULL_USER_INFO, { queryParams: { user_id } })
                .then(response => {
                    setNameInfo({
                        first_name: response?.first_name,
                        last_name: response?.last_name,
                        pn: response?.pn,
                    });
                    setUserInfo(response);
                    setIsDataLoading(false);
                })
                .catch(error => {
                    setError(error);
                    setIsDataLoading(false);
                });
        }

        showInfo(!isInfoShown);
    }

    return <div className={style.component}>
        <Link className={style.id_title}
              onClick={getUserInfo}
              ytLog={!isInfoShown ? ytLogData : undefined}> Провести идентификацию </Link>

        {isInfoShown
            ? isDataLoading
                ? <Spin/>
                : <>
                    <div className={style.blackbox_item_title}>ФИО</div>
                    <div className={style.blackbox_item}>
                        {error
                            ? <ShortError error={error}/>
                            : <span>{UserInfoHandler.getPrintName.call(nameInfo)}</span>}
                    </div>

                    <div className={style.blackbox_item_title}>ДАТА РОЖДЕНИЯ</div>
                    <div className={style.blackbox_item}>
                        <FormatDate value={UserInfoHandler.getBirthDay.call(userInfo)} onlyDate/>
                    </div>

                    <div className={style.blackbox_item_title}>РЕГИСТРАЦИЯ</div>
                    <div className={style.blackbox_item}>
                        <FormatDate value={UserInfoHandler.getRegistration.call(userInfo)} onlyDate/>
                    </div>

                    {BlockRules.UserLogin
                        ? <>
                            <div className={style.blackbox_item_title}>
                                <span>username</span>: <Copy>{UserInfoHandler.getUsername.call(userInfo)}</Copy>
                            </div>
                            <div className={style.blackbox_item}>
                                <span>email</span>: <Copy>{UserInfoHandler.getEmail.call(userInfo)}</Copy>
                            </div>
                        </> : null
                    }

                    <div className={style.blackbox_item_title}>МЕСТО РОЖДЕНИЯ</div>
                    <div className={style.blackbox_item}>
                        <span>{UserInfoHandler.getBirthPlace.call(userInfo)}</span>
                    </div>

                    <div className={style.blackbox_item_title}>МЕСТО ЖИТЕЛЬСТВА</div>
                    <div className={style.blackbox_item}>
                        <span>{UserInfoHandler.getRegistrationPlace.call(userInfo)}</span>
                    </div>

                    <div className={style.blackbox_item_title}>UID</div>
                    <div className={style.blackbox_item}>
                        <Copy>{UserInfoHandler.getUid.call(userInfo)}</Copy>
                    </div>
                </>
            : null
        }
    </div>;
};
