import * as React from 'react';
import { RefObject } from 'react';

import { EMPTY_DATA, HALF_SECOND } from '../../../../constants';
import { Link } from '../../../../ui/Link';
import * as style from '../index.css';

interface ICommentBlockProps {
    comment: string;
}

interface ICommentBlockState {
    collapsed: boolean;
    linesAmount: number;
}

const MAX_LINES_AMOUNT = 3;

export class CommentBlock extends React.Component<ICommentBlockProps, ICommentBlockState> {
    state: ICommentBlockState = {
        collapsed: true,
        linesAmount: 0,
    };
    spanRef: RefObject<HTMLSpanElement> | null = React.createRef();

    componentDidMount() {
        window.addEventListener('resize', this.onResize);

        setTimeout(() => {
            this.onResize();
        }, HALF_SECOND);
    }

    componentWillUnmount() {
        window.removeEventListener('resize', this.onResize);
    }

    setCollapsed() {
        this.setState({ collapsed: !this.state.collapsed });
    }

    onResize = () => {
        const length = this.spanRef?.current?.getClientRects()?.length;

        if (this.state.linesAmount !== length) {
            this.setState({ linesAmount: length ?? 0 });
        }
    };

    render() {
        const { comment } = this.props;
        const { collapsed, linesAmount } = this.state;

        return <div>
            <div className={`${style.description} ${style.comment_block} ${collapsed ? style.collapsed : ''}`}>
                <span ref={this.spanRef}>
                    {comment}
                </span>
            </div>
            {comment && comment !== EMPTY_DATA && linesAmount > MAX_LINES_AMOUNT
                && <Link onClick={this.setCollapsed.bind(this)}>{collapsed ? 'Развернуть' : 'Свернуть'}</Link>}
        </div>;
    }
}
