import * as React from 'react';
import ReactJson from 'react-json-view';

import { EMPTY_DATA } from '../../../../constants';
import { Button, ButtonTypes } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import * as coreStyle from '../../../../ui/index.css';
import * as style from '../index.css';

interface IShowTagDetailsProps {
    tagData: any;
    onClose: () => void;
}

export class ShowTagDetails extends React.Component<IShowTagDetailsProps, {}> {
    render() {
        const tagName = `Тег: ${this.props.tagData
        && (this.props.tagData.display_name
            || this.props.tagData.tag
            || this.props.tagData.tag_display_name
            || EMPTY_DATA)}`;

        return <Window title={tagName} onClose={this.props.onClose}>
            <div className={`small-modal-dialog tag-detail ${style.tag_details}`}>
                <ReactJson src={this.props.tagData} collapsed={2} enableClipboard={false} displayDataTypes={false}/>
                <div className={coreStyle.button_container}>
                    <Button basic
                            colorType={ButtonTypes.negative}
                            onClick={this.props.onClose.bind(this)}>Закрыть</Button>
                </div>
            </div>
        </Window>;
    }
}
