import * as React from 'react';
//@ts-ignore
import ReactJson from 'react-json-view';

import { EMPTY_DATA, ONE_SECOND } from '../../../../constants';
import FormatDate from '../../../../ui/FormatDate';
import { Window } from '../../../../ui/FullModal';
import { Link } from '../../../../ui/Link';
import * as styleTable from '../../../../ui/Table/index.css';
import { Request2 } from '../../../../utils/request';
import { SimpleError } from '../../../SimpleError';
import Spin from '../../../Spin';
import * as style from '../index.css';
import { CORE_USER_INFO_REQUESTS as requestConfigs, REQUESTS } from '../request';

export class TagsDeepHistory extends React.Component<any> {
    componentDidMount(): void {
        this.getData();
    }

    state = {
        isLoading: false,
        rows: [],
        users: {},
        error: null,
        showTagInfoIsOpen: false,
        tag: {},
    };

    request = new Request2({
        requestConfigs,
    });

    getData() {
        this.setState({
            isLoading: true,
        }, () => {
            this.request.exec(REQUESTS.GET_USER_DEEP_HISTORY_TAGS, {
                queryParams: {
                    user_id: this.props.user_id,
                    WithUsers: true,
                },
            })
                .then(response => {
                    this.setState({
                        isLoading: false,
                        rows: response && response.Rows
                            && Array.isArray(response.Rows)
                            && response.Rows.reverse() || [],
                        users: response && response.Users
                            && Array.isArray(response.Users)
                            && response.Users.reduce((_p, _c) => {
                                return { ..._p, [_c.ID]: _c };
                            }, {}) || {},
                    });
                })
                .catch(error => {
                    this.setState({
                        error,
                        isLoading: false,
                        rows: [],
                        users: {},
                    });
                });
        });
    }

    showTagInfo(showTagInfoIsOpen: boolean, tag: any) {
        this.setState({
            showTagInfoIsOpen: showTagInfoIsOpen,
            tag,
        });
    }

    render() {
        return <Window title={`Архив истории тегов пользователя ${this.state.rows && `(${this.state.rows.length})`}`}
                       className={style.archive}
                       onClose={this.props.onClose}>
            <div className={style.deep_history}>
                <div>
                    {
                        this.state.isLoading
                            ? <Spin/>
                            : this.state.error
                                ? <SimpleError error={this.state.error}/>
                                : <div>
                                    {
                                        this.state.showTagInfoIsOpen &&
                                    <Window onClose={this.showTagInfo.bind(this, false, null)}>
                                        <div>
                                            <h4>Подробнее ро теге:</h4>
                                            <ReactJson src={this.state.tag}
                                                       collapsed={4}
                                                       enableClipboard={false}/>
                                        </div>
                                    </Window>
                                    }
                                    {this.state.rows.length && <table className={styleTable.table}>
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Action</th>
                                                <th>Timestamp</th>
                                                <th>Tag</th>
                                                <th>HistoryUserID</th>
                                                <th>Performer</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            {
                                                this.state.rows.map((item: any, index) => {
                                                    return <Row item={item}
                                                                index={index}
                                                                key={index}
                                                                users={this.state.users}
                                                                showTagInfo={this.showTagInfo.bind(this, true, item)}/>;
                                                })
                                            }
                                        </tbody>
                                    </table>
                                    }
                                </div>
                    }
                </div>
            </div>
        </Window>;
    }
}

const Row = React.memo((props: { item: any; index: number; showTagInfo: () => void; users: any }) => {
    let { item, index, showTagInfo, users } = props;

    return <tr key={item.HistoryEventID}>
        <td>{++index}</td>
        <td className={`action ${item.HistoryAction}`}>{item.HistoryAction}</td>
        <td>
            <FormatDate value={item.HistoryTimestamp * ONE_SECOND} withSecond/>
        </td>
        <td>
            <div className={'tag'}>{item.Tag}</div>
            <div className={'tag_name'}>{item.Name}</div>
        </td>
        <td>{
            item.HistoryUserID.indexOf('robot') > -1 ? item.HistoryUserID :
                <Link href={`#/clients/${item.HistoryUserID}/info`}>{users?.[item?.HistoryUserID]?.Username}</Link>}
        </td>
        <td>{item.Performer ?
            <Link href={`#/clients/${item.Performer}/info`}>{users?.[item?.Performer]?.Username}</Link>
            : EMPTY_DATA}
        </td>
        <td>
            <Link onClick={showTagInfo}>info</Link>
        </td>
    </tr>;
});
