import { IComponentRequest } from '../../../../utils/request';

export enum REQUESTS {
    GET_USER_HISTORY_TAGS = 'GET_USER_HISTORY_TAGS',
    GET_ACCOUNT_HISTORY_TAGS = 'GET_ACCOUNT_HISTORY_TAGS',
    GET_FINES_SETTINGS = 'GET_FINES_SETTINGS',
}

export const requestConfigs: IComponentRequest = {
    [REQUESTS.GET_USER_HISTORY_TAGS]: {
        api: 'users/tags_history',
        cgiObj: {
            object_id: null,
            duration: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.GET_ACCOUNT_HISTORY_TAGS]: {
        api: 'account/tag/history',
        cgiObj: {
            object_id: null,
            duration: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.GET_FINES_SETTINGS]: {
        api: 'settings/info',
        cgiObj: {
            prefix: null,
        },
    },
};
