import * as React from 'react';

import { Link } from '../../../../ui/Link';
import { OUTGOING_COMMUNICATION } from './constants';

export const ChatLink = React.memo((props: { item; title?: any }) => {
    const { item } = props;
    const user_id = item.object_id;
    const chat_id = item.topic_link || item?.tag_details?.topic_link;
    const tags_name = item.tag || item.tag_name;
    const route = chat_id?.includes(OUTGOING_COMMUNICATION) ? 'outgoing' : 'chats';

    return user_id && chat_id
        ? <Link target={'_blank'}
                href={`#/${route}?user_id=${user_id}&chat_id=${chat_id}&tag_names=${tags_name}&tag_id=${item.tag_id}`}>
            {props.title ?? 'Чат'}
        </Link>
        : null;
});
