import * as React from 'react';

import { Dict } from '../../../../../../types';

interface IUserTagItemLink {
    index: number;
    _index: number;
    link: Dict<any> ;
}

const TAG_NAME_CELLS = 3;
const COMMENT_CELLS = 7;

export const UserTagItemLink = React.memo((props: IUserTagItemLink) => {
    const { index, link, _index } = props;

    return <tr className={'tag-links'} key={`${index}_${_index}`}>
        <td colSpan={TAG_NAME_CELLS}/>
        <td>{_index + 1}) {link.type}</td>
        <td colSpan={COMMENT_CELLS} className={'_link'}>{link.uri}</td>
    </tr>;
});
