import * as React from 'react';

import { Dict } from '../../../../../../types';
import { EMPTY_DATA, ONE_SECOND } from '../../../../../constants';
import FormatDate from '../../../../../ui/FormatDate';
import { Link } from '../../../../../ui/Link';
import { IBlockRules } from '../../../../../utils/IBlockRules';
import { CommentBlock } from '../../CommentBlock';
import * as style from '../../index.css';
import { shouldShowTagComment } from '../../shouldShowTagComment';
import { ChatLink } from '../ChatLink';
import { UserTagItemLink } from '../UserTagItemLink/component';
import { UserTagModal } from '../UserTagModal/component';
import UserTagRoutModal from '../UserTagRoutModal';

interface IUserTagItemProps extends IBlockRules {
    index: number;
    element: Dict<any>;
    evolutions: Dict<any>;
    finesTags: any;
    removeTag: (id: string) => void;
    openEditTag: (element: Dict<any>) => void;
    openEvolveTag: (element: Dict<any>) => void;
    showTagDetails: (element: Dict<any>) => void;
}

interface IUserTagItemState {
    isModalOpen: boolean;
    routTag: any;
}

const SERVICE_ROUTE_TAG = 'service_route_tag';
const SCORING_ALERT = 'scoring_alert';
export class UserTagItem extends React.Component<IUserTagItemProps, IUserTagItemState> {
    state: IUserTagItemState = {
        isModalOpen: false,
        routTag: null,
    };

    onItemClick() {
        this.setState({ isModalOpen: true });
    }

    onWindowClose() {
        this.setState({ isModalOpen: false });
    }

    showRout(routTag) {
        this.setState({ routTag });
    }

    render() {
        const {
            index,
            element,
            finesTags,
            removeTag,
            openEditTag,
            openEvolveTag,
            showTagDetails,
            evolutions,
        } = this.props;
        const count = element.length;
        const item = element[0];

        return <>
            {
                this.state.routTag
                && <UserTagRoutModal tag={this.state.routTag}
                                     onClose={this.showRout.bind(this, null)}/>
            }
            <tr onClick={count > 1 ? this.onItemClick.bind(this) : null}>
                <td>{index + 1}</td>
                <td>
                    <div className={count > 1 ? style.elements_count : style.hiddenElement}>
                        <div className={style.label_data}>{count}</div>
                    </div>
                </td>
                <td><TagIcon finesTags={finesTags} tag={item.tag}/></td>
                <td>
                    <strong>{item.display_name}</strong>
                    <div className={style.description}>
                        {item.tag !== item.display_name ? item.tag : ''}
                    </div>
                </td>
                <td>{item.tag === SCORING_ALERT
                    ? <ul>{item?.states_times?.map((el, index) => {
                        return <li key={index}>
                            <FormatDate value={el * ONE_SECOND}
                                        withSecond/> - <strong>{item?.states_history?.[index]}</strong>
                        </li>;
                    })}</ul>
                    : shouldShowTagComment(item.tag, this.props.BlockRules)
                        ? <CommentBlock comment={item.comment}/>
                        : null}
                </td>
                <td><ChatLink item={item}/></td>
                <td>
                    {
                        item.tag === SERVICE_ROUTE_TAG && item?.route?.routing_task_id
                            ? <Link onClick={this.showRout.bind(this, item)}>маршрут</Link>
                            : count === 1
                                ? item.session_id
                                    ? <Link href={`#/session/${item.session_id}`}> сессия </Link>
                                    : EMPTY_DATA
                                : null
                    }
                </td>
                <td>
                    {count === 1
                        ? <div className={style.parent_id}>
                            {item.parent_id
                                ? <Link target={'_blank'}
                                        href={`#/b2b/search-wallets?parent_id=${item.parent_id}`}>
                                    id: {item.parent_id}
                                </Link>
                                : EMPTY_DATA}
                            <Link onClick={showTagDetails.bind(this, item)}> info </Link>
                        </div>
                        : null
                    }
                </td>
                <td>
                    {count === 1
                        ? <div className={`${style.tag_controls}`}>
                            <div className={`${style.tag_controls_item}`}><span>●</span>
                                <Link onClick={openEditTag.bind(this, item)}>Редактор</Link></div>
                            {evolutions?.[item.tag] && !item.hasOwnProperty('topic_link')
                            && <div className={`${style.tag_controls_item}`}><span>●</span>
                                <Link onClick={openEvolveTag.bind(this, item)}>
                                    Эволюция</Link></div>}
                            {removeTag && <div className={`${style.tag_controls_item}`}>
                                <span className={style.remove}>●</span>
                                <Link onClick={removeTag.bind(this, item.tag_id)}>Удалить</Link>
                            </div>}
                        </div>
                        : null
                    }
                </td>
            </tr>
            {...item.links && element.length === 1
            && item.links.map((link: { uri: string; type: string }, _index: number) => {
                return link
                    ? <UserTagItemLink index={index} _index={_index} link={link}/>
                    : null;
            })}
            {this.state.isModalOpen
                ? <UserTagModal onWindowClose={this.onWindowClose?.bind(this)}
                                showTagDetails={showTagDetails?.bind(this)}
                                openEditTag={openEditTag?.bind(this)}
                                openEvolveTag={openEvolveTag?.bind(this)}
                                finesTags={finesTags}
                                removeTag={removeTag?.bind(this)}
                                evolutions={evolutions}
                                element={element}/>
                : null
            }
        </>;
    }
}

const TagIcon = (props: { finesTags: string; tag: string }) => {
    let icon = '';
    if (props.finesTags && props.finesTags.split(',').includes(props.tag)) {
        icon = '💰';
    }

    return (
        <span>{icon}</span>
    );
};
