import * as React from 'react';

import { Dict } from '../../../../../../types';
import { Window } from '../../../../../ui/FullModal';
import * as styleTable from '../../../../../ui/Table/index.css';
import * as style from '../../index.css';
import UserTagItem from '../UserTagListItem';

interface IUserTagModalProps {
    element: Dict<any>;
    evolutions: Dict<any>;
    finesTags: any;
    onWindowClose: () => void;
    removeTag: (id: string) => void;
    openEditTag: (element: Dict<any>) => void;
    openEvolveTag: (element: Dict<any>) => void;
    showTagDetails: (element: Dict<any>) => void;
}

export const UserTagModal = React.memo((props: IUserTagModalProps) => {
    const {
        onWindowClose,
        element,
        removeTag,
        finesTags,
        openEditTag,
        openEvolveTag,
        showTagDetails,
        evolutions,
    } = props;

    return <Window title={'Просмотр тегов пользователя'}
                   onClose={onWindowClose.bind(null)}
                   className={style.modal}>
        <div className={style.modal_table}>
            <table className={styleTable.table}>
                <tbody>
                    {element.map((item, index) => {
                        return <UserTagItem key={index}
                                            index={index}
                                            element={[item ?? {}]}
                                            evolutions={evolutions}
                                            removeTag={removeTag?.bind(null, item.tag_id)}
                                            finesTags={finesTags}
                                            openEditTag={openEditTag?.bind(null, item)}
                                            openEvolveTag={openEvolveTag?.bind(null, item)}
                                            showTagDetails={showTagDetails?.bind(null, item)}/>;
                    })}
                </tbody>
            </table>
        </div>
    </Window>;
});
