import * as React from 'react';

import { Dict } from '../../../../../types';
import * as styleTable from '../../../../ui/Table/index.css';
import { deepCopy } from '../../../../utils/utils';
import TagModal from '../../../TagModal';
import { ITag, OBJECT_TYPES, Operations } from '../../../TagModal/component';
import { ShowTagDetails } from '../ShowTagDetails';
import UserTagItem from './UserTagListItem';

const BUTTONS_CELLS = 4;

export class UserCurrentTagList extends React.Component<any, any> {
    state = {
        showTagDetails: false,
        tagData: {},
        compressedData: {},
        isTagEditingOpen: false,
        evolveTag: false,
        editingTag: null,
    };

    componentDidMount() {
        if (this.props.data?.length) {
            const compressedData = this.compressData();
            this.setState({ compressedData });
        }
    }

    closeTagDetails() {
        this.setState({
            showTagDetails: false,
            tagData: {},
        });
    }

    showTagDetails(tagData: any, e: KeyboardEvent) {
        this.setState({
            showTagDetails: true,
            tagData,
        });
    }

    openEditTag(editingTag: ITag) {
        this.setState({ isTagEditingOpen: true, editingTag });
    }

    openEvolveTag(editingTag: ITag) {
        this.setState({ isTagEditingOpen: true, evolveTag: true, editingTag });
    }

    closeEditTag() {
        this.setState({ isTagEditingOpen: false, evolveTag: false, editingTag: null }, () => {
            this.props?.updateData?.();
        });
    }

    closeWithoutUpdate(newTag?: any) {
        let newData;

        if (newTag) {
            const { compressedData, editingTag }: any = this.state;
            newData = Object.assign({}, compressedData);

            const editingTagGroup = newData[editingTag.display_name] ?? [];
            const prevTag = editingTagGroup.find(el => el.tag_id === editingTag.tag_id);
            editingTagGroup.splice(editingTagGroup.indexOf(prevTag), 1, newTag ?? {});
        } else {
            newData = this.state.compressedData;
        }

        this.setState({ compressedData: newData, isTagEditingOpen: false, editingTag: null });
    }

    compressData(): Dict<object> {
        const result = {};
        const data = this.props.data;

        data.forEach(el => {
            if (result.hasOwnProperty(el.display_name)) {
                result[el.display_name].push(el);
            } else {
                result[el.display_name] = [el];
            }
        });

        return result;
    }

    render() {
        const { compressedData, editingTag } = this.state;
        const copyTag = deepCopy(editingTag || {});

        return <div>
            {
                this.state.showTagDetails
                && <ShowTagDetails onClose={this.closeTagDetails.bind(this)}
                                   tagData={this.state.tagData}/>
            }
            {
                <table className={`${styleTable.table} ${styleTable.clearHover}`}>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th/>
                            <th/>
                            <th>Тег/Описание</th>
                            <th>Комментарий</th>
                            <th colSpan={BUTTONS_CELLS}/>
                        </tr>
                    </thead>
                    <tbody>
                        {Object.values(compressedData)?.map((item: Dict<any>, index: number) => {
                            return <UserTagItem key={index}
                                                index={index}
                                                element={item}
                                                evolutions={this.props?.evolutions}
                                                finesTags={this.props.finesTags}
                                                removeTag={this.props.removeTag?.bind(this)}
                                                openEditTag={this.openEditTag.bind(this)}
                                                openEvolveTag={this.openEvolveTag.bind(this)}
                                                showTagDetails={this.showTagDetails.bind(this)}/>;
                        })
                        }
                    </tbody>
                </table>
            }
            {
                (this.state.isTagEditingOpen && !this.state.evolveTag)
                    ? <TagModal objectId={{ type: OBJECT_TYPES.USER }}
                                operation={Operations.EDIT}
                                initialData={copyTag}
                                onClose={this.closeWithoutUpdate.bind(this)}/>
                    : (this.state.isTagEditingOpen && this.state.evolveTag) ?
                        <TagModal operation={Operations.EVOLUTION}
                                  evolutionTag={copyTag}
                                  onClose={this.closeEditTag.bind(this)}/> : null
            }
        </div>;
    }
}
