import { Dict } from '../../../../../types';
import { controlType, ISchemaItem, SchemaItemVisual } from '../../../FormConstructor/types';
import { IS_FIRST_RIDING_TITLE } from '../../DocumentsView/constants';

const USER_STATUS_VARIANTS = {
    active: 'active',
    debt: 'debt',
    onboarding: 'onboarding',
    blocked: 'blocked',
};
export const USER_MODEL = {
    id: null,
    first_name: null,
    last_name: null,
    pn: null,
    status: null,
    username: null,
    uid: null,
    setup: {
        phone:
            { number: null, verified: false },
        email:
            { address: null, verified: false },
    },
    is_mechanic_transmission_allowed: false,
    is_first_riding: false,
    tags: [],
    passport_revision: null,
    driving_license_revision: null,
    documents: {
        passport: {
            ['']: {
                doc_value: null,
                first_name: null,
                last_name: null,
                middle_name: null,
                birth_place: null,
                citizenship: null,
                gender: null,
                subdivision_code: null,
                birth_date: null,
                issue_date: null,
                issued_by: null,
                registration_apartment: null,
                registration_housing: null,
                registration_house: null,
                registration_letter: null,
                registration_street: null,
                registration_locality: null,
                registration_area: null,
                registration_region: null,
                expiration_date: null,
                biographical_country: null,
                registration_country: null,
                registration_expiration_date: null,
            },

        },
        driving_license: {
            ['']: {
                first_name: null,
                last_name: null,
                middle_name: null,
                number_front: null,
                number_back: null,
                prev_licence_number: null,
                categories: null,
                birth_date: null,
                issue_date: null,
                issued_by: null,
                experience_from: null,
                prev_licence_issue_date: null,
                categories_b_valid_from_date: null,
                categories_b_valid_to_date: null,
                front_country: null,
                back_country: null,
            },
        },
    },
};
export const USER_MODEL_DESC: Dict<{ title: string; fields: Dict<ISchemaItem> }> = {
    commonUserInfo: {
        title: 'Общая информация',
        fields: {
            id: { display_name: 'id', type: controlType.string, order: 1 },
            first_name: { display_name: 'Имя', type: controlType.string, order: 2 },
            last_name: { display_name: 'Фамилия', type: controlType.string, order: 3 },
            pn: { display_name: 'Отчество', type: controlType.string, order: 4 },
            status: {
                display_name: 'Статус',
                type: controlType.variants,
                variants: Object.keys(USER_STATUS_VARIANTS),
                editable: true,
                multi_select: false,
            },
            username: { display_name: 'Логин', type: controlType.string },
            uid: { display_name: 'uid', type: controlType.numeric },
            phone: { display_name: 'Телефон', type: controlType.string },
            phoneVerified: { display_name: 'Подтверждение телефона', type: controlType.bool },
            email: { display_name: 'email', type: controlType.string },
            is_mechanic_transmission_allowed: {
                display_name: 'Допуск к управлению механической КП',
                type: controlType.bool,
            },
            is_first_riding: {
                display_name: IS_FIRST_RIDING_TITLE,
                type: controlType.bool,
            },
        },

    },
    userPassportInfo: {
        title: 'Паспорт',
        fields: {
            doc_value: { display_name: 'Номер паспорта', type: controlType.string, order: 1 },
            first_name: { display_name: 'Имя', type: controlType.string, order: 2 },
            last_name: { display_name: 'Фамилия', type: controlType.string, order: 3 },
            middle_name: { display_name: 'Отчество', type: controlType.string, order: 4 },
            birth_place: { display_name: 'Место рождения', type: controlType.string },
            citizenship: { display_name: 'Гражданство', type: controlType.string },
            gender: { display_name: 'Пол', type: controlType.string },
            subdivision_code: { display_name: 'Код подразделения, выдавшего паспорт', type: controlType.string },
            birth_date: { display_name: 'Дата рождения', type: controlType.string, visual: SchemaItemVisual.DATE_ISO },
            issue_date: {
                display_name: 'Дата выдачи паспорта',
                type: controlType.string,
                visual: SchemaItemVisual.DATE_ISO,
            },
            issued_by: {
                display_name: 'Место выдачи',
                type: controlType.string,
            },
            registration_apartment: { display_name: 'Квартира', type: controlType.string },
            registration_housing: { display_name: 'Корпус', type: controlType.string },
            registration_house: { display_name: 'Дом', type: controlType.string },
            registration_letter: { display_name: 'Литера дома', type: controlType.string },
            registration_street: { display_name: 'Улица', type: controlType.string },
            registration_locality: { display_name: 'Район', type: controlType.string },
            registration_area: { display_name: 'Населённый пункт', type: controlType.string },
            registration_region: { display_name: 'Регион/Область/Республика', type: controlType.string },
            expiration_date: {
                display_name: 'Дата истечения',
                type: controlType.string,
                visual: SchemaItemVisual.DATE_ISO,
            },
            biographical_country: { display_name: 'Биогр., страна', type: controlType.string },
            registration_country: { display_name: 'Регистрация, страна', type: controlType.string },
            registration_expiration_date: {
                display_name: 'Срок окончания временной регистрации',
                type: controlType.string,
                visual: SchemaItemVisual.DATE_ISO,
            },
        },

    },
    userDrivingLicenseInfo: {
        title: 'Водительское удостоверение',
        fields: {
            categories: { display_name: 'Категории', type: controlType.string, order: 1 },
            first_name: { display_name: 'Имя', type: controlType.string, order: 2 },
            last_name: { display_name: 'Фамилия', type: controlType.string, order: 3 },
            middle_name: { display_name: 'Отчество', type: controlType.string, order: 4 },
            number_front: { display_name: 'Номер спереди ВУ', type: controlType.string },
            number_back: { display_name: 'Номер сзади ВУ', type: controlType.string },
            prev_licence_number: { display_name: 'Номер предыдущего ВУ', type: controlType.string },
            birth_date: { display_name: 'Дата рождения', type: controlType.string, visual: SchemaItemVisual.DATE_ISO },
            issue_date: {
                display_name: 'Дата выдачи ВУ',
                type: controlType.string,
                visual: SchemaItemVisual.DATE_ISO,
            },
            issued_by: {
                display_name: 'Кем выдан',
                type: controlType.string,
            },
            experience_from: {
                display_name: 'С какой даты опыт вождения',
                type: controlType.string,
                visual: SchemaItemVisual.DATE_ISO,
            },
            prev_licence_issue_date: {
                display_name: 'Дата выдачи прошлого ВУ',
                type: controlType.string,
                visual: SchemaItemVisual.DATE_ISO,
            },
            categories_b_valid_from_date: {
                display_name: 'С какой даты действует категория B',
                type: controlType.string,
                visual: SchemaItemVisual.DATE_ISO,
            },
            categories_b_valid_to_date: {
                display_name: 'До какой даты действует категория B',
                type: controlType.string,
                visual: SchemaItemVisual.DATE_ISO,
            },
            front_country: { display_name: 'Страна выдачи ВУ спереди ВУ', type: controlType.string },
            back_country: { display_name: 'Страна выдачи ВУ сзади ВУ', type: controlType.string },
        },

    },
};
