import * as React from 'react';
//@ts-ignore
import ReactJson from 'react-json-view';

import { Dict } from '../../../../types';
import { UserInfoHandler } from '../../../models/user';
import { Button, ButtonTypes } from '../../../ui/Button';
import { Confirm, Window } from '../../../ui/FullModal';
import * as coreStyle from '../../../ui/index.css';
import { UserStatuses } from '../../../ui/Status';
import { IBlockRules } from '../../../utils/IBlockRules';
import { Request2 } from '../../../utils/request';
import { buttonLocationDetails } from '../../../utils/sendLogs/eventTypes/buttonDetails';
import { Translate } from '../../../utils/translate';
import { IStore } from '../../App/store';
import FastTagsView from '../../FastTagsView';
import { IFastTagItem } from '../../InterfaceAdminConfig/FastTags/schema';
import Spin from '../../Spin';
import TagModal from '../../TagModal';
import { OBJECT_TYPES } from '../../TagModal/component';
import TagsDeepHistory2 from '../../TagsDeepHistory2';
import * as style from './index.css';
import { CORE_USER_INFO_REQUESTS as requestConfigs, REQUESTS } from './request';
import { ShowTagDetails } from './ShowTagDetails';
import TagsHistory from './TagsHistory';
import { HISTORY_TYPES } from './TagsHistory/component';
import { UserCurrentTagList } from './UserCurrentTagList';
import UserEditor from './UserEditor';

interface IUserInfoViewProps extends IStore, IBlockRules {
    userId: string;
    finesTags: string;
    evolutions?: Dict<any>;
}

interface IUserInfoViewState {
    confirmIsOpen: boolean;
    question: string;
    accept: any;
    isWorking: boolean;
    attachTagIsOpen: boolean;
    tagIsAttaching: boolean;
    tagsIsLoading: boolean;
    usersTag: any[];
    fastTag: IFastTagItem | null;
    confirmDeleteIsOpen: boolean;
    deleteHandler: () => void;
    userEditorIsOpen: boolean;
    tagData: any;
    showTagDetails: boolean;
    isDocsQueuePickerOpen: boolean;
    showDeepHistory: boolean;
    removeTagError: Error | null;
    userInfo: Dict<any>;
    workingError: Error | null;
    eventDetailsError: Error | null;
    eventDetailsIsLoading: boolean;
    eventDetailsIsOpen: boolean;
    eventDetailsData: Dict<any> | null;
}

export default class UserInfoView extends React.Component<IUserInfoViewProps, IUserInfoViewState> {
    state: IUserInfoViewState = {
        confirmIsOpen: false,
        question: 'Продолжить?',
        accept: null,
        isWorking: false,
        attachTagIsOpen: false,
        tagIsAttaching: false,
        tagsIsLoading: false,
        usersTag: [],
        fastTag: null,
        confirmDeleteIsOpen: false,
        deleteHandler: () => null,
        userEditorIsOpen: false,
        tagData: null,
        showTagDetails: false,
        isDocsQueuePickerOpen: false,
        showDeepHistory: false,
        removeTagError: null,
        userInfo: {},
        workingError: null,
        eventDetailsIsLoading: false,
        eventDetailsData: null,
        eventDetailsIsOpen: false,
        eventDetailsError: null,
    };
    request = new Request2({
        requestConfigs,
    });
    t = this.props.Lang && new Translate(this.props.Lang) || {} as Translate;

    componentDidMount() {
        if (this.props.userId) {
            this.request.exec(REQUESTS.GET_USER_INFO, { queryParams: { user_id: this.props.userId } })
                .then((userInfo) => {
                    this.setState({ userInfo }, () => {
                        this.getUsersTags();
                    });
                });
        }
    }

    componentDidUpdate(prevProps: Readonly<IUserInfoViewProps>): void {
        if (this.props.userId && prevProps.userId !== this.props.userId) {
            this.getUsersTags();
        }
    }

    onClose() {
        this.setState({
            confirmIsOpen: false,
            isWorking: false,
            confirmDeleteIsOpen: false,
        });
    }

    getUsersTags() {
        this.setState({
            tagsIsLoading: true,
        }, () => {
            this.request.exec(REQUESTS.GET_USER_TAGS, { queryParams: { object_id: this.props.userId } })
                .then(response => {
                    const usersTag = response.records || [];

                    this.setState({
                        tagsIsLoading: false,
                        usersTag,
                    });
                });
        });
    }

    sendForm() {
        const fullUserName = UserInfoHandler.getPrintName.call(this.state.userInfo);
        const userName = UserInfoHandler.getName.call(this.state.userInfo);

        const carsharing_reservation = this.state.userInfo.order && this.state.userInfo.order.items
            && this.state.userInfo.order.items.filter((item: any) => item.type === 'carsharing_reservation');
        const obj = carsharing_reservation
            && carsharing_reservation.length
            && carsharing_reservation[0]['carsharing_reservation']
            || {};
        const number = obj && obj.car && obj.car.number || '';
        const href = `https://forms.yandex-team.ru/surveys/17084/?user_name=${
            encodeURIComponent(userName)
        }&full_user_name=${
            encodeURIComponent(fullUserName)
        }&user_phone=${encodeURIComponent(UserInfoHandler.getPhone.call(this.state.userInfo))}&user_email=${
            UserInfoHandler.getEmail.call(this.state.userInfo)}&auto_id=${encodeURIComponent(number)}`;
        window.open(href, '_blank');
    }

    attachTag() {
        this.setState({ attachTagIsOpen: true });
    }

    closeAttachTag() {
        this.setState({ attachTagIsOpen: false, fastTag: null }, () => {
            this.getUsersTags();
        });
    }

    removeTag(id: string) {
        this.setState(
            {
                confirmDeleteIsOpen: true,
                deleteHandler: () => {
                    this.setState({ isWorking: true, removeTagError: null }, () => {
                        this.request.exec(REQUESTS.REMOVE_USER_TAG, { queryParams: { tag_id: id } })
                            .then(() => {
                                this.onClose();
                                if (this.props.userId) {
                                    this.getUsersTags();
                                }
                            })
                            .catch((removeTagError) => {
                                this.setState({ isWorking: false, removeTagError });
                            });
                    });
                },
            });
    }

    openUserEditor() {
        this.setState({
            userEditorIsOpen: true,
        });
    }

    closeUserEditor() {
        this.setState({
            userEditorIsOpen: false,
        });
    }

    closeTagDetails() {
        this.setState({
            tagData: null,
            showTagDetails: false,
        });
    }

    showTagDetails(tagData: any) {
        this.setState({
            tagData,
            showTagDetails: true,
        });
    }

    showTagEventDetails(tagData) {
        const { event_id } = tagData;
        this.setState({
            eventDetailsIsOpen: true,
            eventDetailsIsLoading: true,
        }, () => {
            this.request.exec(REQUESTS.GET_USER_TAG_DETAILS, { queryParams: { event_id } })
                .then(eventDetailsData => {
                    this.setState({
                        eventDetailsData,
                        eventDetailsIsLoading: false,
                    });
                })
                .catch(eventDetailsError => {
                    this.setState({
                        eventDetailsError,
                        eventDetailsIsLoading: false,
                    });
                });
        });
    }

    closeTagEventDetails() {
        this.setState({
            eventDetailsIsOpen: false,
            eventDetailsData: null,
            eventDetailsError: null,
            eventDetailsIsLoading: false,
        });
    }

    openDocsQueuePicker() {
        this.setState({ isDocsQueuePickerOpen: true });
    }

    closeDocsQueuePicker() {
        this.setState({ isDocsQueuePickerOpen: false });
    }

    showTagsDeepHistory(showDeepHistory: boolean) {
        this.setState({ showDeepHistory });
    }

    deleteUser() {
        this.setState({
            confirmIsOpen: true,
            question: `Удалить пользователя?`,
            accept: () => {
                this.setState({
                    isWorking: true,
                }, () => {
                    this.request.exec(REQUESTS.DELETE_USER, { queryParams: { user_id: this.props.userId } })
                        .then(() => {
                            this.onClose();
                            this.getUsersTags();
                        });
                });
            },
        });
    }

    registrationNewApprove() {
        this.setState({
            confirmIsOpen: true,
            question: 'Зарегистрировать пользователя?',
            accept: () => {
                this.setState({ isWorking: true }, () => {
                    this.request
                        .exec(REQUESTS.REGISTRATION_NEW_APPROVE, { queryParams: { user_id: this.props.userId } })
                        .then(() => {
                            this.getUsersTags();
                            this.onClose();
                        })
                        .catch((workingError) => {
                            this.setState({
                                workingError,
                                isWorking: false,
                            });
                        });
                });
            },
        });
    }

    openTagModal(fastTag: IFastTagItem | null) {
        this.setState({
            attachTagIsOpen: true,
            fastTag,
        });
    }

    render() {
        return <div className={style.user_info}>
            <div className={style.button_container}>
                {
                    this.props.BlockRules && this.props.BlockRules.RegistrationEdit
                        ? <Button onClick={this.openUserEditor.bind(this)}
                                  isLoading={this.state.isWorking}>Редактирование</Button>
                        : null
                }

                {
                    this.props.BlockRules && this.props.BlockRules.UserDelete
                        ? <Button colorType={ButtonTypes.negative}
                                  onClick={this.deleteUser.bind(this)}>☠️ Удалить пользователя</Button>
                        : null
                }
                {
                    this.props.BlockRules && this.props.BlockRules.CallCenterOperator
                        ? <Button colorType={ButtonTypes.negative}
                                  onClick={this.sendForm.bind(this)}>Передать в ФОС</Button>
                        : null
                }
                {this.props?.BlockRules?.RegisterUser
                && [UserStatuses.REJECTED, UserStatuses.ON_BOARDING, UserStatuses.SCREENING, UserStatuses.FAST_REG]
                    .includes(this.state.userInfo.status)
                    ? <Button className={style.register_button}
                              colorType={ButtonTypes.positive}
                              onClick={this.registrationNewApprove.bind(this)}>Зарегистрировать</Button>
                    : null
                }
                <Button colorType={ButtonTypes.positive}
                        basic
                        onClick={this.showTagsDeepHistory.bind(this, true)}>Архив тегов</Button>
                <FastTagsView place={buttonLocationDetails.CLIENT_INFO}
                              addTag={this.openTagModal.bind(this)}/>
            </div>
            <div className={'log'}>
                <div className={'user-tags'}>
                    {
                        this.state.showTagDetails
                        && <ShowTagDetails onClose={this.closeTagDetails.bind(this)}
                                           tagData={this.state.tagData}/>
                    }
                    {
                        this.state.eventDetailsIsOpen
                        && <ShowTagEventDetailsDialog onClose={this.closeTagEventDetails.bind(this)}
                                                      isLoading={this.state.eventDetailsIsLoading}
                                                      error={this.state.eventDetailsError}
                                                      data={this.state.eventDetailsData}/>
                    }
                    <h2 className={style.block_title}>Теги:</h2>
                    <div className={style.add_button_container}>
                        <Button colorType={ButtonTypes.positive}
                                onClick={this.attachTag.bind(this)}>Добавить тег</Button>
                    </div>
                    {
                        this.state.tagsIsLoading
                            ? <Spin/>
                            : <UserCurrentTagList data={this.state.usersTag}
                                                  evolutions={this.props?.evolutions}
                                                  finesTags={this.props.finesTags}
                                                  updateData={this.getUsersTags.bind(this)}
                                                  removeTag={this.removeTag.bind(this)}/>
                    }
                    {
                        this.state.attachTagIsOpen
                        && <TagModal objectId={
                            {
                                type: OBJECT_TYPES.USER,
                                id: this.state.userInfo && this.state.userInfo.id || this.props.userId,
                            }
                        }
                                     onClose={this.closeAttachTag.bind(this)}
                                     initialData={this.state.fastTag || null}/>
                    }
                    {
                        this.state.confirmDeleteIsOpen
                        && <Confirm onClose={this.onClose.bind(this)}
                                    question={'Удалить тег?'}
                                    error={this.state.removeTagError}
                                    isWorking={this.state.isWorking}
                                    accept={this.state.deleteHandler.bind(this)}/>
                    }
                </div>

                <h4>История тегов:</h4>
                <TagsHistory object_id={this.props.userId}
                             historyType={HISTORY_TYPES.USER}
                             isUpdating={this.state.tagsIsLoading}
                             showTagDetails={this.showTagDetails.bind(this)}
                             showTagEventDetails={this.showTagEventDetails.bind(this)}/>
            </div>
            {this.state.userEditorIsOpen
            && <UserEditor onClose={this.closeUserEditor.bind(this)} userId={this.props.userId}/>}
            {
                this.state.showDeepHistory
                && <TagsDeepHistory2 onClose={this.showTagsDeepHistory.bind(this, false)}
                                     user_id={this.props.userId}/>
            }
            {this.state.confirmIsOpen
                ? <Confirm accept={this.state.accept}
                           isWorking={this.state.isWorking}
                           question={this.state.question}
                           error={this.state.workingError}
                           onClose={this.onClose.bind(this)}/>
                : null}
        </div>;
    }
}

const ShowTagEventDetailsDialog = React.memo((props: { isLoading; data; onClose; error }) => {
    const { isLoading, data, onClose, error } = props;
    const title = data?.tag_name ? `${data.tag_name}: ${data?.action}` : '';

    return <Window title={title} onClose={onClose} error={error}>
        <div className={`small-modal-dialog tag-detail ${style.tag_details}`}>
            {isLoading
                ? <Spin/>
                : <ReactJson src={data} collapsed={2} enableClipboard={false} displayDataTypes={false}/>
            }
            <div className={coreStyle.button_container}>
                <Button basic
                        colorType={ButtonTypes.negative}
                        onClick={onClose}>Закрыть</Button>
            </div>
        </div>
    </Window>;
});
