import { connect } from 'react-redux';

import { getRawSetting } from '../../../utils/getRawSetting';
import { IStore } from '../../App/store';
import { FINES_TAGS } from '../../FinesDownPaymentsDialog';
import UserInfoView from './component';

export const mapStateToProps = (store: IStore) => {
    const finesTags = getRawSetting(store, FINES_TAGS);

    return {
        Lang: store.Lang,
        BlockRules: store.AdminUser?.blockRules,
        finesTags,
        evolutions: store.AdminUser?.permissions?.evolutions,
    };
};

export default connect(mapStateToProps)(UserInfoView);
