import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_USER_TAGS = 'GET_USER_TAGS',
    GET_USER_TAG_DETAILS = 'GET_USER_TAG_DETAILS',
    REMOVE_USER_TAG = 'REMOVE_USER_TAG',
    GET_USER_DEEP_HISTORY_TAGS = 'GET_USER_DEEP_HISTORY_TAGS',
    ATTACH_USER_TAG = 'ATTACH_USER_TAG',
    EDIT_USER_INFO = 'EDIT_USER_INFO',
    DELETE_USER = 'DELETE_USER',
    GET_USER_INFO = 'GET_USER_INFO',
    GET_FULL_USER_INFO = 'GET_FULL_USER_INFO',
    GET_USER_HISTORY_INFO = 'GET_USER_HISTORY_INFO',
    REGISTRATION_NEW_APPROVE = 'REGISTRATION_NEW_APPROVE',
}

export const CORE_USER_INFO_REQUESTS: IComponentRequest = {
    [REQUESTS.REMOVE_USER_TAG]: {
        api: 'user_tags/remove',
        cgiObj: {
            tag_id: null,
        },
    },
    [REQUESTS.GET_USER_TAGS]: {
        api: 'user_tags/list',
        cgiObj: {
            object_id: null,
        },
    }, [REQUESTS.GET_USER_TAG_DETAILS]: {
        api: 'user/tag/history/details',
        cgiObj: {
            event_id: null,
        },
    },

    [REQUESTS.GET_USER_DEEP_HISTORY_TAGS]: {
        apiPrefix: API_PREFIXES.ANALYTICS_PRESTABLE,
        api: 'analytics/tags-history/users/${user_id}',
        cgiObj: {
            WithUsers: null,
        },
    },
    [REQUESTS.ATTACH_USER_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'user_tags/add',
    },
    [REQUESTS.EDIT_USER_INFO]: {
        method: REQUEST_METHOD.POST,
        api: 'user/edit',
        cgiObj: {
            validate: 'false',
        },
    },
    [REQUESTS.DELETE_USER]: {
        api: 'user/delete',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_USER_INFO]: {
        api: 'user/report',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_FULL_USER_INFO]: {
        api: 'user/info',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_USER_HISTORY_INFO]: {
        api: 'user/history',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.REGISTRATION_NEW_APPROVE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'user/register-force',
        cgiObj: {
            user_id: null,
        },
    },
};
