import moment from 'moment';
import * as React from 'react';

import { ONE_WEEK_IN_DAYS } from '../../../constants';
import { Collapse } from '../../../ui/Collapse';
import { Request2 } from '../../../utils/request';
import GetCalls from '../../Support/GetCalls/component';
import { CLIENTS_CARD_REQUESTS as requestConfigs, REQUESTS } from '../request';
import UserRequests from '../UserRequests2';
import { RequestUserType } from '../UserRequests2/component';
import AddPush from './AddPush';
import { IMapStateToProps } from './index';

interface IUserRequestAggregatorProps extends IMapStateToProps {
    userId: string;
}

interface IUserRequestAggregatorState {
    tags: any | null;
    error: Error | null;
}

export default class UserRequestAggregator extends
    React.Component<IUserRequestAggregatorProps, IUserRequestAggregatorState> {
    state: IUserRequestAggregatorState = {
        tags: null,
        error: null,
    };
    request = new Request2({
        requestConfigs,
    });

    componentWillUnmount() {
        this.request.abort();
    }

    componentDidMount(): void {
        this.request.exec(REQUESTS.GET_TAGS)
            .then(response => {
                this.setState({
                    tags: response.records && Array.isArray(response.records)
                        && response.records.reduce((_p, _c) => {
                            if (!_p.hasOwnProperty(_c.name) && _c.display_name) {
                                _p[_c.name] = _c.display_name;
                            }

                            return _p;
                        }, {}) || {},
                });
            });
    }

    render() {
        const id = this.props.operatorId;
        const imOperator = id === this.props.userId;

        return <div>
            <AddPush user_id={this.props.userId}/>
            <UserRequests id={this.props.userId} user_type={RequestUserType.user} tags={this.state.tags} samsara/>
            <UserRequests id={this.props.userId} user_type={RequestUserType.performer} tags={this.state.tags}/>
            <hr/>

            <Collapse title={'Стааааааарые обращения'} collapsed={false}>
                {
                    imOperator
                    && <div>
                        <h3>Я оператор</h3>
                        <GetCalls agentIdFilter={id}
                                  since={+moment().subtract(ONE_WEEK_IN_DAYS, 'd')}
                                  fixedNumber={false}/>
                    </div>
                }
                {
                    imOperator && <h3>Я клиент</h3>
                }
                <GetCalls fixedNumber={true}
                          userId={this.props.userId}/>
            </Collapse>
        </div>;
    }
}
