import React, { useState } from 'react';

import { Link } from '../../../ui/Link';
import style from '../index.css';
import { ListenWPCall } from './ListenWPCall';

interface ICallLinkProps {
    tag: any;
    linkLabel?: any;
    className?: string;
}

export const CallLink = React.memo((props: ICallLinkProps) => {
    const { linkLabel, tag, className } = props;
    const [isModalOpen, openModal] = useState<boolean>(false);

    return <div className={style.call_link}>
        {tag.call?.bucket && tag.call?.key
            ? <Link onClick={openModal.bind(null, true)} className={className}>
                {linkLabel ?? '► прослушать'}
            </Link>

            : tag.call?.url
                ? <Link href={tag.call.url} target={'_blank'} className={className}>
                    {linkLabel ?? '► прослушать'}
                </Link>
                : null
        }

        {isModalOpen
            ? <ListenWPCall tag={tag} onClose={openModal.bind(null, false)}/>
            : null
        }
    </div>;
});
