import React from 'react';

import { ONE_SECOND } from '../../../constants';
import FormatDate from '../../../ui/FormatDate';
import * as style from '../UserRequests2/index.css';

const match_sams = 'sams';

export const Dates = ({ tag }) => {
    return <>
        {(tag.call?.enter || tag.call?.connect)
        && <>
            {
                !tag.call?.enter && <div className={style.empty_enter}>недозвон</div> || ''
            }
            <FormatDate value={(tag.call?.enter || tag.call?.connect) * ONE_SECOND}
                        className={`${style.timestamp} ${style.date}`}
                        onlyDate/>
            <div>
                <FormatDate value={(tag.call?.enter || tag.call?.connect) * ONE_SECOND}
                            className={`${style.timestamp} ${style.time}`}
                            onlyTime/> -
                <FormatDate value={tag.call?.exit * ONE_SECOND}
                            className={style.timestamp}
                            onlyTime/>
            </div>
        </>
        || <FormatDate value={tag?.timestamp * ONE_SECOND}
                       className={`${style.timestamp} ${style.not_call}`}
                       withSecond/>
        }

        {
            (tag?.tag_name === match_sams && tag?.timestamp !== tag?.dateOpen) && <div>
                <FormatDate value={tag?.dateOpen * ONE_SECOND}
                            className={`${style.timestamp} ${style.not_call}`}
                            withSecond/>
            </div>
        }
    </>;
};
