import React from 'react';

import { useRequestHandler } from '../../../hooks/useRequestHandler';
import { Window } from '../../../ui/FullModal';
import { Request2 } from '../../../utils/request';
import Spin from '../../Spin';
import { requestConfigs, REQUESTS } from '../UserRequests2/request';
import { CallDuration } from './CallDuration';
import { Dates } from './Dates';

export const ListenWPCall = (props) => {
    const request = new Request2({ requestConfigs });

    const requestOptions = React.useMemo(() => {
        return {
            requestName: REQUESTS.LISTEN_CALL,
            requestOptions: {
                queryParams: {
                    bucket: props.tag.call.bucket,
                    key: props.tag.call.key,
                },
                blob: true,
                headers: {
                    'Content-Type': 'audio/wav',
                },
            },
        };
    }, []);

    const handler = (response) => {
        return URL.createObjectURL(response);
    };

    const [isLoading, response, error, getAudio] = useRequestHandler(request, requestOptions, handler);

    React.useEffect(() => {
        getAudio();
    }, []);

    React.useEffect(() => {
        return () => {
            request.abort();
        };
    }, []);

    return <Window title={'Слушаем звоночек'} onClose={props.onClose} error={error}>
        <div>
            <Dates tag={props.tag}/>
            <CallDuration tag={props.tag}/>
        </div>
        <div>
            {isLoading && <Spin size={'s'}/>}
        </div>
        <div>
            {response && <audio controls src={response} controlsList="nodownload"/>}
        </div>
    </Window>;
};
