import React from 'react';

import CheckboxIcon from '../../../../../../svg-components/requests-svg/checkbox.component.svg';
import style from './index.css';

export const SuccessCallCheckbox = React.memo((props: { isActive: boolean; changeActive: () => void }) => {
    return <div className={style.success_checkbox} onClick={props.changeActive.bind(null)}>
        <Checkbox isActive={props.isActive}/>
        <span>Показывать только обращения с дозвоном</span>
    </div>;
});

const Checkbox = React.memo((props: { isActive: boolean }) => {
    return props.isActive
        ? <CheckboxIcon className={style.active}/>
        : <div className={style.inactive}/>;
});
