import React, { useState } from 'react';

import PlusIcon from '../../../../../../svg-components/requests-svg/plus.component.svg';
import { ClassificationType } from '../../../../../../types';
import ClassificationDialog from '../../../../Chats/ClassificationDialog';
import { REQUEST_TYPES } from '../../constants';
import style from './index.css';

const AllowedTypes = [
    REQUEST_TYPES.incoming,
    REQUEST_TYPES.outgoing,
    REQUEST_TYPES.dispatcher,
    REQUEST_TYPES.chat,
    REQUEST_TYPES.smm,
];

export function isAllowedToClassify(type) {
    return AllowedTypes.includes(type);
}

export const ReqClassification = React.memo((props: {
    userId: string;
    tag: any;
    ignoreEllipse?: boolean;
    type: REQUEST_TYPES;
}) => {
    const { userId, tag, ignoreEllipse, type } = props;
    const [isClassificationOpen, setClassificationOpen] = useState(false);

    const comment = tag.tag_details?.comment ?? '';
    const classifications = tag.categorization?.items ?? [];
    const tagId = tag.tag_id ?? tag.tag_details?.tag_id;
    const chatId = tag.tag_details?.topic_link;
    const isAllowedType = isAllowedToClassify(type);

    if (isAllowedType) {
        const tagComment = comment
            ? <div className={style.tag_comment}>
                Комментарий к тегу:
                {comment}
            </div>
            : null;

        if (classifications.length) {
            return <>
                {tagComment}

                {classifications.map((el) => {
                    return <span key={el.id} className={style.cl_item_wrapper}>
                        <div className={`${style.classification_item} ${style.exist_class_item}`}
                             title={el.category.meta?.label}
                             onClick={setClassificationOpen.bind(null, true)}>
                            {el.category.meta?.label}
                        </div>
                        <div className={`${style.class_item_comment} ${ignoreEllipse ? style.full_comment : ''}`}>
                            {el.comment ?? ''}
                        </div>
                    </span>;
                })}

                {isClassificationOpen
                    ? <ClassificationDialog onClose={setClassificationOpen.bind(null, false)}
                                            onClassified={setClassificationOpen.bind(null, false)}
                                            user_id={userId}
                                            tag_id={tagId}
                                            chat_id={chatId}
                                            type={getClassificationType(tag)}/>
                    : null
                }
            </>;
        }

        return <>
            {tagComment}

            <div className={`${style.classification_item} ${style.new_class_item}`}
                 onClick={setClassificationOpen.bind(null, true)}>
                <PlusIcon className={style.plus}/>
                    Разметить
            </div>

            {isClassificationOpen
                ? <ClassificationDialog onClose={setClassificationOpen.bind(null, false)}
                                        onClassified={setClassificationOpen.bind(null, false)}
                                        user_id={userId}
                                        tag_id={tagId}
                                        chat_id={chatId}
                                        type={getClassificationType(tag)}/>
                : null
            }
        </>;

    }

    return null;

});

function getClassificationType(tag) {
    if (tag.tag_name?.includes('outgoing_call')) {
        return ClassificationType.call_outgoing;
    }

    if (tag.tag_name?.includes('cc_internal')) {
        return ClassificationType.call_incoming;
    }

    if (tag.tag_details?.topic_link) {
        return ClassificationType.chat;
    }

    return ClassificationType.call;
}
