import React from 'react';

import { ONE_SECOND } from '../../../../../constants';
import { Link } from '../../../../../ui/Link';

export const samsaraAdapter = (samsaraTickets) => {
    return samsaraTickets?.map(tic => {
        return {
            timestamp: Math.floor(tic?.params?.dateCreate?.value / ONE_SECOND),
            dateOpen: Math.floor(tic?.params?.dateOpen?.value / ONE_SECOND),
            tag_name: 'email',
            status: tic?.params?.status?.value,
            sams_link: <Link href={`https://samsara.yandex-team.ru/ticket/${tic.ticketId}/articles`}
                             target={'_blank'}>
                Тикет #{tic?.params?.ticketNumber?.value}
            </Link>,
        };
    });
};
