import React from 'react';

import ChatIcon from '../../../../../../svg-components/requests-svg/chat.component.svg';
import DispatcherIcon from '../../../../../../svg-components/requests-svg/dispatcher.component.svg';
import EmailIcon from '../../../../../../svg-components/requests-svg/email.component.svg';
import IncomingIcon from '../../../../../../svg-components/requests-svg/incoming.component.svg';
import IntroScreenIcon from '../../../../../../svg-components/requests-svg/introScreen.component.svg';
import OutgoingIcon from '../../../../../../svg-components/requests-svg/outgoing.component.svg';
import PushIcon from '../../../../../../svg-components/requests-svg/push.component.svg';
import SmmIcon from '../../../../../../svg-components/requests-svg/smm.component.svg';
import SmsIcon from '../../../../../../svg-components/requests-svg/sms.component.svg';
import { REQUEST_TYPES } from '../../constants';
import style from './index.css';

interface IRequestTypeProps {
    type: string;
    label: string;
    activeState: boolean;
    onClick: () => void;
    className?: string;
}

export const RequestTypeControl = React.memo((props: IRequestTypeProps) => {
    const { type, label, activeState, onClick, className } = props;

    return <div className={`${style.control} ${activeState ? style.active : style.inactive} ${className ?? ''}`}
                onClick={onClick.bind(null)}>
        {generateIcon(type, { className: style.icon })}
        <div className={style.label}>{label}</div>
    </div>;
});

const MAX_ICONS = 3;

export const RequestTypeControlMini = React.memo((props: {typesArr: REQUEST_TYPES[]}) => {
    const { typesArr = [] } = props;

    return (
        <div className={style.container}>
            {typesArr.slice(0, MAX_ICONS).reverse().map((type, index) => {
                if(!REQUEST_TYPES[type]) {return;}

                const params = {
                    className: `${style.icon_mini} ${typesArr.length > 1 ? style.icon_multiple : ''}`,
                    key: `${type}-${index}`,
                };

                return generateIcon(type, params);
            },
            )}
        </div>
    );
});

const generateIcon = (type, params) => {
    switch (type) {
    case REQUEST_TYPES.dispatcher:
        return <DispatcherIcon {...params}/>;
    case REQUEST_TYPES.outgoing:
        return <OutgoingIcon {...params}/>;
    case REQUEST_TYPES.incoming:
        return <IncomingIcon {...params}/>;
    case REQUEST_TYPES.chat:
        return <ChatIcon {...params}/>;
    case REQUEST_TYPES.email:
        return <EmailIcon {...params}/>;
    case REQUEST_TYPES.push:
        return <PushIcon {...params}/>;
    case REQUEST_TYPES.introScreen:
        return <IntroScreenIcon {...params}/>;
    case REQUEST_TYPES.smm:
        return <SmmIcon {...params}/>;
    case REQUEST_TYPES.sms:
        return <SmsIcon {...params}/>;
    default:
        return null;
    }
};
