import React from 'react';

import { REQUEST_TYPES, RequestTypesTranslate } from '../../constants';
import style from './index.css';
import { RequestTypeControl } from './RequestTypeControl';

interface IRequestTypePanelProps {
    requestTypes: {
        [type in REQUEST_TYPES]: boolean
    };
    onClick: (type: REQUEST_TYPES) => void;
}

export const RequestTypePanel = React.memo((props: IRequestTypePanelProps) => {
    const requestTypeEntries = Object.entries(props.requestTypes) ?? [];

    return requestTypeEntries?.length
        ? <div className={`${style.panel}`}>
            {requestTypeEntries?.map((el) => {
                const type = el[0];

                return <RequestTypeControl key={type}
                                           type={type}
                                           label={RequestTypesTranslate[type]}
                                           onClick={props.onClick.bind(null, type)}
                                           activeState={el[1]}/>;
            })}
        </div>
        : null;
});
