import React, { useState } from 'react';

import MoreControlIcon from '../../../../../../svg-components/requests-svg/more-control.component.svg';
import OpenLiteIcon from '../../../../../../svg-components/requests-svg/open-lite.component.svg';
import { ReqClassification } from '../ClassificationLabels/component';
import { RequestTypeControlMini } from '../RequestTypesPanel/RequestTypeControl';
import { TagDetailsModal } from '../TagDetailsModal/component';
import style from './index.css';
import { getReqDay, getReqTime, getRequestType, ReqEntity, ReqLink, ReqOperatorLink } from './RequestsTableHelpers';

interface IRequestTableTRProps {
    tag: any;
    index: number | string;
    isOpened?: boolean;
    tagsDescription: any;
    userId: string;
    isTimeline: boolean;
    users: any[];

    showChildren?: (tag) => void;
}

export const RequestTableTR = React.memo((props: IRequestTableTRProps) => {
    const { tag, index, isOpened, tagsDescription, userId, isTimeline, users, showChildren } = props;

    const [tagForModal, setTagForModal] = useState();

    const type = getRequestType(tagsDescription, tag);
    const typesArr = [type];
    const date = getReqDay(tag);
    const time = getReqTime(tag);
    const isChildTag = tag.task_tag;
    const isHighlighted = isChildTag || isOpened;

    if (tag.children) {
        tag.children.map(tag => {
            typesArr.push(getRequestType(tagsDescription, tag));
        });
    }

    return <>
        <tr className={`${isChildTag && !isTimeline ? style.child_tag : ''} ${tag.children ? style.click_tr : ''}`}
            onClick={tag.children ? showChildren?.bind(null, tag) : null}>
            <td className={`${style.index} ${isHighlighted ? style.mark : ''}`}>{index}</td>

            <td className={style.icons_td}>
                {type ?
                    <RequestTypeControlMini typesArr={typesArr}/>
                    : null
                }
            </td>

            <td className={style.date}>
                <div>
                    {date ? <div>{date}</div> : null}
                    {time ? <div className={style.time}>{time}</div> : null}
                </div>
            </td>

            <td>
                <ReqLink tag={tag} type={type}/>
            </td>

            <td>
                <ReqEntity tagDescription={tagsDescription} tag={tag}/>
            </td>

            <td>
                <ReqClassification tag={tag} userId={tag.object_id ?? userId} type={type}/>
            </td>

            <td>
                <ReqOperatorLink users={users} tag={tag} userId={userId}/>
            </td>

            <td>
                {tag.children
                    ? <div className={style.control_more} onClick={showChildren?.bind(null, tag)}>
                        <OpenLiteIcon className={`${style.open_control} ${!isOpened ? style.close : ''}`}/>
                    </div>
                    : <div className={style.control_more} onClick={setTagForModal.bind(null, tag)}>
                        <MoreControlIcon/>
                    </div>
                }
            </td>
        </tr>

        {tag.children && isOpened
            ? tag.children.map(el => {
                return <RequestTableTR key={el.tag_id}
                                       tag={el}
                                       tagsDescription={tagsDescription}
                                       index={''}
                                       isTimeline={isTimeline}
                                       userId={userId}
                                       users={users}/>;
            })
            : null
        }

        {tagForModal
            ? <TagDetailsModal onClose={setTagForModal.bind(null, null)}
                               tag={tagForModal}
                               tagDescription={tagsDescription}
                               users={users}
                               userId={tag.object_id ?? userId}
                               type={type}/>
            : null
        }
    </>;
});
