import React, { useState } from 'react';

import PlusIcon from '../../../../../../svg-components/requests-svg/plus.component.svg';
import { AttachUserRequestModal } from '../../../../Header/CallsNotify/AttachUserRequestModal';
import style from '../ClassificationLabels/index.css';

interface IBindUserProps {
    tag: any;
}

export const BindUser = React.memo((props: IBindUserProps) => {
    const [isModalOpened, openModal] = useState<boolean>(false);

    const attachValues = {
        tag_id: props.tag?.tag_id ?? props.tag?.tag_details?.tag_id,
        call_id: props.tag?.tag_details?.call_id ?? '',
        user_id: props.tag?.object_id ?? '',
    };

    return <>
        <PlusIcon className={style.plus}
                  onClick={openModal.bind(null, true)}/>
        {isModalOpened
            ? <AttachUserRequestModal openBindClientModal={openModal.bind(null, false)}
                                      values={attachValues}/>
            : null
        }
    </>;
});
