import React, { useState } from 'react';

import { Dict } from '../../../../../../types';
import { UserInfoHandler } from '../../../../../models/user';
import { Window } from '../../../../../ui/FullModal';
import { JsonModal } from '../../../../../ui/FullModal/JsonModal';
import { Link } from '../../../../../ui/Link';
import { REQUEST_TYPES } from '../../constants';
import { isAllowedToClassify, ReqClassification } from '../ClassificationLabels/component';
import {
    getReqDay,
    getReqTime,
    ReqEntity,
    ReqLink,
    ReqOperatorLink,
} from '../RequestsTable/RequestsTableHelpers';
import { BindUser } from './BindUser';
import style from './index.css';

interface ITagDetailsModalProps {
    onClose: () => void;
    tag: any;
    tagDescription: Dict<any>;
    users: any[];
    userId: string;
    type: REQUEST_TYPES;
}

export const TagDetailsModal = React.memo((props: ITagDetailsModalProps) => {
    const { onClose, tag, tagDescription, users, userId, type } = props;
    const [isDetailsOpened, openDetails] = useState(false);
    const typeOfReq = tagDescription[tag.tag_name]?.display_name ?? tag.tag_name;
    const date = getReqDay(tag);
    const time = getReqTime(tag);
    const title = `${typeOfReq} ${date} ${time}`;
    const userInfo = users.find(el => el.id === userId) ?? {};
    const userName = UserInfoHandler.getPrintName.call(userInfo);
    const userLink = `#/clients/${userId}/info`;
    const operatorId = props.tag.tag_details?.performer;
    const isAllowToClassify = isAllowedToClassify(type);
    const isAllowToBindUser = type === REQUEST_TYPES.incoming;

    return <>
        <Window onClose={onClose.bind(null)} title={title} className={style.tag_details}>
            <table className={style.table}>
                <tbody>
                    {userName && userLink
                        ? <tr>
                            <td className={style.table_key}>
                            Клиент
                            </td>
                            <td>
                                {userName
                                    ? <div className={style.client}>
                                        <Link href={userLink} target={'_blank'}>{userName}</Link>

                                        {isAllowToBindUser ? <BindUser tag={tag}/> : null}
                                    </div>
                                    : null
                                }
                            </td>
                        </tr>
                        : null
                    }

                    {operatorId
                        ? <tr>
                            <td className={style.table_key}>
                            Оператор
                            </td>
                            <td>
                                {!(userName && userLink)
                                    ? <div className={style.client}>
                                        <ReqOperatorLink users={users} tag={tag}/>

                                        {isAllowToBindUser ? <BindUser tag={tag}/> : null}
                                    </div>

                                    : <ReqOperatorLink users={users} tag={tag}/>
                                }
                            </td>
                        </tr>
                        : null
                    }

                    <tr>
                        <td className={style.table_key}>
                        Обращение
                        </td>
                        <td>
                            <ReqLink tag={tag} type={type}/>
                        </td>
                    </tr>

                    <tr>
                        <td className={style.table_key}>
                        Очередь
                        </td>
                        <td>
                            <ReqEntity tagDescription={tagDescription} tag={tag}/>
                        </td>
                    </tr>
                </tbody>
            </table>

            {isAllowToClassify
                ? <>
                    <div className={style.separator}/>

                    <div className={style.classification}>
                        <div className={`${style.classification_head} ${style.table_key}`}>
                            Классификация
                        </div>

                        <ReqClassification tag={tag} userId={userId} ignoreEllipse={true} type={type}/>
                    </div>
                </>
                : null
            }

            <div className={style.separator}/>

            <Link onClick={openDetails.bind(null, true)} className={style.details}>
                Подробная информация
            </Link>
        </Window>

        {isDetailsOpened
            ? <JsonModal obj={tag} onClose={openDetails.bind(null, false)}/>
            : null
        }
    </>;
});
