import moment from 'moment';
import React from 'react';

import { ONE_WEEK_IN_DAYS } from '../../../constants';
import { Collapse } from '../../../ui/Collapse';
import { Collapse2 } from '../../../ui/Collapse2';
import { SimpleError } from '../../SimpleError';
import Spin from '../../Spin';
import GetCalls from '../../Support/GetCalls/component';
import AddPush from '../UserRequestAggregator/AddPush';
import HeaderToolbar from './ChildrenComponents/HeaderToolbar';
import { RequestsTable } from './ChildrenComponents/RequestsTable/component';
import { IMapStateToProps } from './index';
import style from './index.css';

interface IUserRequestsProps extends IMapStateToProps {
    userId: string;
}

interface IUserRequestsState {
    samsaraLoading: boolean;
    isLoading: boolean;
    error: Error | null;
    data: any;
}

export class UserRequests extends React.Component<IUserRequestsProps, IUserRequestsState> {
    state: IUserRequestsState = {
        samsaraLoading: false,
        isLoading: false,
        error: null,
        data: {},
    };

    render() {
        const { userId, operatorId } = this.props;
        const { isLoading, samsaraLoading, error, data } = this.state;
        const isOperator = userId === operatorId;

        return <div className={style.component}>
            <AddPush user_id={userId}/>

            <HeaderToolbar userId={this.props.userId}
                           setData={(data) => this.setState({ data })}
                           setError={(error) => this.setState({ error })}
                           setSamsaraLoading={(samsaraLoading) => this.setState({ samsaraLoading })}
                           setLoading={(isLoading) => this.setState({ isLoading })}/>

            {isLoading
                ? <div className={style.centered}>
                    <Spin size={'l'}/>
                </div>
                : error
                    ? <Collapse2 title={'Ошибка получения данных'}
                                 children={<SimpleError error={error}/>}
                                 headerClassname={style.error}/>
                    : null
            }

            {samsaraLoading
                ? <h4 className={style.warn}>Загрузка данных из Сансары...</h4>
                : null
            }

            {data?.tags?.length
                ? <RequestsTable data={data} userId={userId}/>
                : !isLoading
                    ? <div className={style.centered}>
                        Обращений этого пользователя не найдено
                    </div>
                    : null
            }

            {!isLoading
                ? <div className={style.collapse}>
                    <Collapse title={'Стааааааарые обращения'} collapsed={true}>
                        {isOperator
                            ? <div>
                                <h3>Я оператор</h3>
                                <GetCalls agentIdFilter={operatorId}
                                          since={+moment().subtract(ONE_WEEK_IN_DAYS, 'd')}
                                          fixedNumber={false}/>
                            </div>
                            : null
                        }

                        {isOperator ? <h3>Я клиент</h3> : null}

                        <GetCalls fixedNumber={true} userId={this.props.userId}/>
                    </Collapse>
                </div>
                : null
            }
        </div>;
    }
}
