export enum REQUEST_TYPES {
    incoming = 'incoming',
    outgoing = 'outgoing',
    chat = 'chat',
    dispatcher = 'dispatcher',
    email = 'email',
    push = 'push',
    introScreen = 'introScreen',
    smm = 'smm',
    sms = 'sms',
}

export const RequestTypesTranslate = {
    [REQUEST_TYPES.incoming]: 'Входящие звонки',
    [REQUEST_TYPES.outgoing]: 'Исходящие звонки',
    [REQUEST_TYPES.chat]: 'Чаты',
    [REQUEST_TYPES.email]: 'Письма',
    [REQUEST_TYPES.introScreen]: 'ИС',
    [REQUEST_TYPES.smm]: 'SMM',
    [REQUEST_TYPES.push]: 'Пуши',
    [REQUEST_TYPES.dispatcher]: 'Исходящая коммуникация',
    [REQUEST_TYPES.sms]: 'СМС',
};

export enum DISPLAY_TYPES {
    events = 'events',
    timeline = 'timeline',
}

export const DisplayTypesTranslate = {
    [DISPLAY_TYPES.events]: 'События',
    [DISPLAY_TYPES.timeline]: 'Хронология',
};

export const REQUEST_TAGS = {
    [REQUEST_TYPES.incoming]: '@user_support_call_tag',
    [REQUEST_TYPES.outgoing]: '@user_outgoing_call,@user_support_ai',
    [REQUEST_TYPES.chat]: '@user_support_chat_tag',
    [REQUEST_TYPES.email]: '@user_mail_notification_tag',
    [REQUEST_TYPES.push]: '@user_push',
    [REQUEST_TYPES.introScreen]: '@user_landing',
    [REQUEST_TYPES.smm]: 'user_support_smm',
    [REQUEST_TYPES.dispatcher]: '@user_outgoing_communication',
    [REQUEST_TYPES.sms]: '@user_sms',
};

export const REQUEST_TYPES_TAGS = {
    user_support_call_tag: REQUEST_TYPES.incoming,
    user_support_ai: REQUEST_TYPES.outgoing,
    user_outgoing_call: REQUEST_TYPES.outgoing,
    user_support_chat_tag: REQUEST_TYPES.chat,
    user_mail_notification_tag: REQUEST_TYPES.email,
    user_push: REQUEST_TYPES.push,
    user_landing: REQUEST_TYPES.introScreen,
    user_dictionary_tag: REQUEST_TYPES.smm,
    user_outgoing_communication: REQUEST_TYPES.dispatcher,
    user_sms: REQUEST_TYPES.sms,
};

export const DEFAULT_TAG = 'user_support_request';

export const DEFAULT_TYPES_TO_SHOW = 4;

const queuesID = 4212;
const ticketsPerPage = 200;
const UTCOffsetMinutes = -180;

export const generateQuery = (fromEmail) => ({
    'query': {
        'article': {
            fromEmail,
            'extData': {},
            'tags': [],
            'types': ['IN', 'OUT'],
            'stLinks': [],
            'partyIdentifiersFrom': {},
        },
        'excludeQueues': false,
        'excludeTags': false,
        'intersectTags': false,
        'priorities': [],
        'statuses': ['NEW', 'HOLD', 'OPEN', 'ARCHIVED', 'CLOSED'],
        'resolutions': [],
        'searchType': 'RECENT',
        'queues': [{ 'id': queuesID, 'withSubQueues': true }],
        'customFields': [],
    },
    'sortDirection': 'DESC',
    'sortField': '',
    'searchType': 'RECENT',
    'page': 0,
    'ticketsPerPage': ticketsPerPage,
    'meta': { 'UTCOffsetMinutes': UTCOffsetMinutes },
});
