import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_REQUESTS = 'GET_REQUESTS',
    GET_EMAILS = 'GET_EMAILS',
    GET_TAGS = 'GET_TAGS',
}

export const requestConfigs: IComponentRequest = {
    [REQUESTS.GET_REQUESTS]: {
        api: 'support/requests',
        cgiObj: {
            since: null,
            until: null,
            performer_id: null,
            user_id: null,
            tags: null,
            rev: null,
        },
    },
    [REQUESTS.GET_EMAILS]: {
        apiPrefix: API_PREFIXES.SAMSARA,
        method: REQUEST_METHOD.POST,
        api: 'searchProto/searchTicket',
    },
    [REQUESTS.GET_TAGS]: {
        api: 'tag/description/list',
    },
};
