import React from 'react';
import ReactTooltip from 'react-tooltip';

import DatePicker from '../../../../ui/DatePicker';
import * as style from './index.css';

export enum FILTER_TYPES {
    PHONE = 'user_support_call_tag',
    SMS = 'user_sms',
    MESSENGER = 'user_support_chat_tag',
    PUSH = 'user_push',
    MAIL = 'user_mail_notification_tag',
    OTHER = 'other',
    OUTGOING = 'user_outgoing_communication',
    WEBPHONE = 'user_outgoing_call',
    INTROSCREENS = 'user_landing',
    SMM = 'user_support_smm',
}

interface IFilterRequestsProps {
    selectedFilters: FILTER_TYPES[] | null;
    selectItem: (item: FILTER_TYPES) => void;
    onChangeDate: (type: string) => void;
    since: any;
    until: any;
}

const TOOLTIP = 'tooltip';

export class FilterRequests extends React.Component<IFilterRequestsProps, any> {
    filterTypes = {
        [FILTER_TYPES.PHONE]: { title: 'Входящий звонок' },
        [FILTER_TYPES.OUTGOING]: { title: 'Исходящий звонок' },
        [FILTER_TYPES.WEBPHONE]: { title: 'WebPhone' },
        [FILTER_TYPES.MESSENGER]: { title: 'Мессенджер' },
        [FILTER_TYPES.PUSH]: { title: 'Пуш-уведомление' },
        [FILTER_TYPES.MAIL]: { title: 'Почта' },
        [FILTER_TYPES.INTROSCREENS]: { title: 'Интроскрины' },
        [FILTER_TYPES.SMS]: { title: 'СМС' },
        [FILTER_TYPES.SMM]: { title: 'СММ' },
        //[FILTER_TYPES.OTHER]: {title: 'Неизвестная очередь'},
    };

    render() {
        return <div className={style.filters}>
            <ReactTooltip id={TOOLTIP} type={'info'}/>
            {
                Object.entries(this.filterTypes).map((item: [FILTER_TYPES, any], key) => {
                    return <div key={key}
                                data-for={TOOLTIP}
                                data-tip={item[1].title}
                                onClick={this.props.selectItem.bind(this, item[0])}
                                className={`${style.filter_item} ${style[`type-${item[0]}`]}`
                                + ` ${this.props.selectedFilters?.includes(item[0]) ? style.active : ''}`}/>;
                })
            }
            <DatePicker className={style.date_picker}
                        value={this.props.since}
                        placeholder={'Oт'}
                        onChange={this.props.onChangeDate.bind(this, 'since')}/>
            <DatePicker className={style.date_picker}
                        value={this.props.until}
                        placeholder={'До'}
                        onChange={this.props.onChangeDate.bind(this, 'until')}/>
        </div>;
    }
}
