import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    ARCHIVE = 'GET_USER_TAGS',
    GET_EMAILS = 'GET_EMAILS',
    LISTEN_CALL = 'LISTEN_CALL',
}

export const requestConfigs: IComponentRequest = {
    [REQUESTS.ARCHIVE]: {
        api: 'support/requests',
        cgiObj: {
            since: null,
            until: null,
            performer_id: null,
            user_id: null,
            tags: null,
            rev: null,
        },
    },
    [REQUESTS.GET_EMAILS]: {
        apiPrefix: API_PREFIXES.SAMSARA,
        method: REQUEST_METHOD.POST,
        api: 'searchProto/searchTicket',
    },
    [REQUESTS.LISTEN_CALL]: {
        api: 'mds/proxy',
        cgiObj:{
            bucket: null,
            key: null,
        },
    },
};

const queuesID = 4212;
const ticketsPerPage = 200;
const UTCOffsetMinutes = -180;
export const generateQuery = (fromEmail) => ({
    'query': {
        'article': {
            fromEmail,
            'extData': {},
            'tags': [],
            'types': ['IN', 'OUT'],
            'stLinks': [],
            'partyIdentifiersFrom': {},
        },
        'excludeQueues': false,
        'excludeTags': false,
        'intersectTags': false,
        'priorities': [],
        'statuses': ['NEW', 'HOLD', 'OPEN', 'ARCHIVED', 'CLOSED'],
        'resolutions': [],
        'searchType': 'RECENT',
        'queues': [{ 'id': queuesID, 'withSubQueues': true }],
        'customFields': [],
    },
    'sortDirection': 'DESC',
    'sortField': '',
    'searchType': 'RECENT',
    'page': 0,
    'ticketsPerPage': ticketsPerPage,
    'meta': { 'UTCOffsetMinutes': UTCOffsetMinutes },
});
