import * as React from 'react';

import { Dict } from '../../../../../types';
import { Button, ButtonTypes } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import coreStyle from '../../../../ui/index.css';
import { Input } from '../../../../ui/Input';
import Select from '../../../../ui/Select';

const TELEGRAM = 'telegram';

interface IAddLoginModalProps {
    onClose: () => void;
    isWorking: boolean;
    createLogin: () => void;
    error: Error | null;
}

interface IAddLoginModalState extends Dict<any> {
    loginId: string;
    loginType: string[];
}

export class AddLoginModal extends React.Component<IAddLoginModalProps, IAddLoginModalState> {
    state: IAddLoginModalState = {
        loginId: '',
        loginType: [TELEGRAM],
    };

    onChange(type: string, event: string) {
        this.setState({
            [type]: event,
        });
    }

    render() {
        return <Window error={this.props.error} title={'Добавление логина'} onClose={this.props.onClose}>
            <div>
                <Select options={[{ text: TELEGRAM, value: TELEGRAM }]}
                        placeholder={'Тип логина'}
                        onSelect={this.onChange.bind(this, 'loginType')}
                        initialValues={this.state.loginType}/>

                <Input placeholder={'логин'}
                       value={this.state.loginId}
                       onChange={this.onChange.bind(this, 'loginId')}/>

                <div className={coreStyle.button_container}>
                    <Button basic
                            colorType={ButtonTypes.negative}
                            onClick={this.props.onClose.bind(this)}>Отмена</Button>
                    <Button colorType={ButtonTypes.positive}
                            isLoading={this.props.isWorking}
                            onClick={this.props.createLogin.bind(this, this.state)}>Создать</Button>
                </div>
            </div>
        </Window>;
    }
}
