import { controlType, SchemaItemVisual } from '../../../FormConstructor/types';

export const TERMLESS = 'Бессрочная';
export const WITH_TERM = 'Со сроком';
export const TO_DATE = 'До даты';

export const schema = {
    variable_field: {
        type: controlType.variable,
        control_field: {
            activeSwitcherValue: {
                type: controlType.variants,
                variants: [TERMLESS, WITH_TERM, TO_DATE],
                default: TERMLESS,
                display_name: 'Срок',
            },
        },
        variants_fields: {
            [WITH_TERM]: {
                deprive_after_days: { type: controlType.numeric, display_name: 'Дней', min: 0 },
            },
            [TO_DATE]: {
                deadline: {
                    type: controlType.numeric,
                    visual: SchemaItemVisual.TIMESTAMP,
                    display_name: 'Дедлайн',
                    order: 2,
                },

            },
        },
    },
    comment: {
        type: controlType.text,
        display_name: 'Обоснование для получения роли',
    },
};
