import React from 'react';

import { ONE_SECOND } from '../../../../constants';
import FormatDate, { displayDuration } from '../../../../ui/FormatDate';
import style from './index.css';

export const FormatDateAndDeadline = (props: { deadline: number }) => {
    const { deadline } = props;
    const deadlineLag = new Date().getTime() - deadline * ONE_SECOND;

    return (
        <>
            <FormatDate value={deadline * ONE_SECOND}/>
            {
                deadlineLag > 0 && <div className={`${style.deadline}`}>
                    <div><strong>Истёк срок действия роли</strong></div>
                    <div>{displayDuration(deadlineLag)} назад</div>
                </div>
            }
        </>

    );
};
