import React, { useState } from 'react';

import { EMPTY_DATA } from '../../../constants';
import { useRequestHandler } from '../../../hooks/useRequestHandler';
import { Window } from '../../../ui/FullModal';
import { Link } from '../../../ui/Link';
import styleTable from '../../../ui/Table/index.css';
import { Tabs } from '../../../ui/Tabs';
import { Request2 } from '../../../utils/request';
import Spin from '../../Spin';
import style from '../index.css';
import { CORE_DRIVE_LENS_REQUESTS as requestConfigs, REQUESTS } from './request';

interface IRoleInfoModalProps {
    onClose: () => void;
    roleId: string;
}

const TabsLinks = {
    actions: 'actions',
    roles: 'roles',
};

export const RoleInfoModal = (props: IRoleInfoModalProps) => {
    const [data, setData]: any = useState({});
    const [selectedTab, setSelectedTab] = useState(TabsLinks.actions);

    const request = new Request2({ requestConfigs });
    const requestOptions = React.useMemo(() => {
        return {
            requestName: REQUESTS.GET_ROLE,
            requestOptions: {
                queryParams: {
                    role_id: props.roleId,
                },
            },
        };
    }, [props.roleId]);

    const responseHandler = (response) => {
        setData(response?.report?.[0]);
    };

    const [isLoading, , error, getRoles] = useRequestHandler<any>(request, requestOptions, responseHandler);

    React.useEffect(() => {
        getRoles();
    }, []);

    const isActionTab = selectedTab === TabsLinks.actions;
    const dataForRender = isActionTab ? data?.actions : data?.slave_roles;
    const tabs = [
        { name: `Экшены (${data?.actions?.length ?? 0})`, link: TabsLinks.actions },
        { name: `Роли (${data?.slave_roles?.length ?? 0})`, link: TabsLinks.roles },
    ];

    return <Window onClose={props.onClose.bind(null)} error={error} title={props.roleId}>
        {isLoading
            ? <Spin/>
            : <div className={style.main_wrapper}>
                <Tabs selectTab={setSelectedTab.bind(null)}
                      tabs={tabs}
                      currentTab={selectedTab}/>

                {dataForRender?.length
                    ? <table className={styleTable.table}>
                        <thead>
                            <tr>
                                <td>#</td>
                                <td><b>id</b></td>
                                <td><b>описание</b></td>
                                <td/>
                            </tr>
                        </thead>

                        <tbody>
                            {isActionTab
                                ? renderActions(dataForRender)
                                : renderRoles(dataForRender)
                            }
                        </tbody>
                    </table>
                    : null
                }
            </div>
        }
    </Window>;
};

const renderActions = (data) => {
    return data?.map((action, index) => {
        const href = `#/settings/actions/${action.action_id}`;

        return <tr key={action.action_id}>
            <td>{index + 1}</td>
            <td>{action.action_id ?? EMPTY_DATA}</td>
            <td>{action.action.action_description ?? EMPTY_DATA}</td>
            <td><Link href={href} target={'_blank'}>edit</Link></td>
        </tr>;
    });
};

const renderRoles = (data) => {
    return data?.map((role, index) => {
        const href = `#/settings/roles?role_id=${role.slave_role_id}`;

        return <tr key={role.role_id}>
            <td>{index + 1}</td>
            <td>{role.slave_role_id ?? EMPTY_DATA}</td>
            <td>{EMPTY_DATA}</td>
            <td><Link href={href} target={'_blank'}>edit</Link></td>
        </tr>;
    });
};
