import moment from 'moment';

import { ONE_SECOND } from '../../../constants';
import { IRoleIDMRequest } from './types';

interface IOptionsForIDMRole {
    comment?: string;
    deprive_after_days?: string;
    deadline?: number;
    selectedRoles: string[];
    user: string;
    system: string;
    simulate?: boolean;
}

export const buildOptionsForIDMRole = (options: IOptionsForIDMRole) => {
    const { comment = '', deprive_after_days = '', deadline, selectedRoles, user, system, simulate = false } = options;
    let deprive_at = '';

    if(deadline) {
        deprive_at = moment(deadline * ONE_SECOND).format('YYYY-MM-DD');
    }

    const requests: IRoleIDMRequest[] = [];

    selectedRoles.map(roleId => {
        requests.push({
            comment,
            deprive_after_days,
            deprive_at,
            user,
            path: `/${roleId}/`,
            user_type: "user",
            sk: "",
            fields_data: {},
            system,
            label: roleId,
            simulate,
        });
    });

    return {
        body: {
            requests,
        },
    };
};
