import moment from 'moment';
import * as React from 'react';
//@ts-ignore
import ReactJson from 'react-json-view';

import { ENVIRONMENT } from '../../../../types';
import { EMPTY_DATA, ONE_SECOND } from '../../../constants';
import { UserInfoHandler } from '../../../models/user';
import { Button } from '../../../ui/Button';
import Checkbox from '../../../ui/Checkbox';
import { Collapse } from '../../../ui/Collapse';
import collapseStyles from '../../../ui/Collapse/index.css';
import FormatDate from '../../../ui/FormatDate';
import { Confirm } from '../../../ui/FullModal';
import { Link } from '../../../ui/Link';
import * as styleTable from '../../../ui/Table/index.css';
import { Request2 } from '../../../utils/request';
import { Translate } from '../../../utils/translate';
import { SimpleError } from '../../SimpleError';
import Spin from '../../Spin';
import { AddLoginModal } from './AddLoginModal';
import { AddManageRole } from './AddManageRole';
import { AddManageRoleIDM } from './AddManageRoleIDM';
import { buildOptionsForIDMRole } from './buildOptionsForIDMRole';
import { FormatDateAndDeadline } from './FormatDateAndDeadline';
import { getEnvironment } from './getEnvironment';
import * as style from './index.css';
import { CORE_DRIVE_LENS_REQUESTS as requestConfigs, REQUESTS } from './request';
import { RoleInfoModal } from './RoleInfoModal';
import { RolesHistory } from './RolesHistory';
import { IRole, IUserRolesViewProps, IUserRolesViewState } from './types';

export default class UserRolesView extends React.Component<IUserRolesViewProps, IUserRolesViewState> {
    environment: ENVIRONMENT;
    state: IUserRolesViewState = {
        dataIsLoading: false,
        roles: [],
        logins: [],
        confirmIsOpen: false,
        addManageRoleIsOpen: false,
        addManageRoleIDMIsOpen: false,
        addManageLoginIsOpen: false,
        dataLoginsIsLoading: false,
        attachTagIsOpen: false,
        accept: () => null,
        isWorking: false,
        question: '',
        currentRole: { role_id: '', deadline: '', active: '', forced: '' },
        access: true,
        permissions: {},
        errPerm: null,
        userInfo: {},
        error: null,
        addManageLoginError: null,
        changeActiveError: null,
        addManageRoleError: null,
        addManageRoleIDMError: null,
        currentRoleId: null,
        requestedIDMRoles: [],
    };
    request = new Request2({
        requestConfigs,
    });
    t = this.props.Lang && new Translate(this.props.Lang) || {} as Translate;

    componentDidMount() {
        this.getData();
        this.getUserInfo();
    }

    componentDidUpdate(prevProps: Readonly<IUserRolesViewProps>, prevState: Readonly<IUserRolesViewState>): void {
        if (prevProps.userId !== this.props.userId) {
            this.getData();
            this.getUserInfo();
        }

        if (prevState.userInfo.username !== this.state.userInfo.username && this.state.userInfo.username) {
            this.getRequestedIDMRoles();
        }
    }

    getRequestedIDMRoles() {
        this.request.exec(REQUESTS.REQUESTED_IDM_ROLES, {
            queryParams: {
                user: this.state.userInfo.username,
                type: "requested",
                system: getEnvironment(),
                no_meta: true,
            },
        })
            .then(response => {
                this.setState({
                    requestedIDMRoles: response?.objects || [],
                });
            });
    }

    getUserInfo() {
        const { userId: user_id } = this.props;

        this.request.exec(REQUESTS.GET_USER_INFO, { queryParams: { user_id } })
            .then(response => {
                this.setState({ userInfo: response });
            });
    }

    onClose() {
        this.setState({
            confirmIsOpen: false,
            isWorking: false,
            attachTagIsOpen: false,
            addManageRoleIsOpen: false,
            addManageRoleIDMIsOpen: false,
            addManageLoginIsOpen: false,
            addManageLoginError: null,
            addManageRoleError: null,
        });
    }

    getData(skipSpinner?: boolean) {
        const props = this.props;

        this.setState({ dataIsLoading: !skipSpinner }, () => {
            this.request.exec(REQUESTS.GET_USER_ROLES, { queryParams: { user_id: props.userId } })
                .then(response => {
                    this.setState(
                        {
                            dataIsLoading: false,
                            roles:
                                response.report
                                && Array.isArray(response.report)
                                && response.report.sort((a, b) => a.role_id.localeCompare(b.role_id))
                                || [],
                        });
                });

            this.request.exec(REQUESTS.GET_USER_PERMISSIONS, { queryParams: { user_id: props.userId } })
                .then(response => {
                    this.setState({
                        permissions: response,
                    });
                })
                .catch(errPerm => {
                    this.setState({
                        errPerm,
                    });
                });
        });

        this.setState({ dataLoginsIsLoading: !skipSpinner }, () => {
            this.request.exec(REQUESTS.GET_USER_LOGINS, { queryParams: { user_id: props.userId } })
                .then((response: any) => {
                    this.setState({ dataLoginsIsLoading: false, logins: response.logins || [] });
                });
        });
    }

    removeRole(item: any) {
        this.setState({
            confirmIsOpen: true,
            question: `Удалить роль ${item.role_id}?`,
            accept: () => {
                this.setState({ isWorking: true }, () => {
                    this.request.exec(REQUESTS.DELETE_USER_ROLE, {
                        queryParams: {
                            user_id: this.props.userId,
                            roles: item.role_id,
                        },
                    })
                        .then(() => {
                            this.setState({ confirmIsOpen: false, isWorking: false, error: null }, () => {
                                this.getData();
                            });
                        })
                        .catch((error) => {
                            this.setState({ isWorking: false, error });
                        });
                });
            },
        });
    }

    removeLogin(item: any) {
        this.setState({
            confirmIsOpen: true,
            question: `Удалить логин ${item.login_id}?`,
            accept: () => {
                this.setState({ isWorking: true }, () => {
                    this.request.exec(REQUESTS.DELETE_USER_LOGIN, {
                        body: {
                            login_id: item.login_id,
                            login_type: item.login_type,
                            user_id: this.props.userId,
                        },
                    })
                        .then(() => {
                            this.setState({ confirmIsOpen: false, isWorking: false, error: null }, () => {
                                this.getData();
                            });
                        })
                        .catch((error) => {
                            this.setState({ isWorking: false, error });
                        });
                });
            },
        });
    }

    addManageRoleHandle(state: any) {
        this.setState({ isWorking: true }, () => {
            this.request.exec(REQUESTS.ADD_USER_ROLE,
                buildOptionsForAddUser({
                    user_id: this.props.userId,
                    ...state,
                }),
            )
                .then(() => {
                    this.setState({ addManageRoleIsOpen: false, isWorking: false, addManageRoleError: null }, () => {
                        this.getData();
                    });
                })
                .catch((addManageRoleError) => {
                    this.setState({ isWorking: false, addManageRoleError });
                });
        });
    }

    addManageRoleIDMHandle(state: any) {
        this.setState({ isWorking: true }, () => {
            this.request.exec(REQUESTS.BATCH_REQUEST_IDM_ROLE,
                buildOptionsForIDMRole({ user: this.state.userInfo.username, system: getEnvironment(), ...state }),
            ).then(() => {
                this.setState({
                    addManageRoleIDMIsOpen: false,
                    isWorking: false,
                    addManageRoleIDMError: null,
                }, () => {
                    this.getData();
                    this.getRequestedIDMRoles();
                });
            })
                .catch((addManageRoleError) => {
                    this.setState({ isWorking: false, addManageRoleError });
                });
        });
    }

    addManageLoginHandle(state: any) {
        this.setState({ isWorking: true }, () => {
            this.request.exec(REQUESTS.ADD_USER_LOGIN, {
                body: {
                    user_id: this.props.userId,
                    login_id: state.loginId,
                    login_type: state.loginType.toString(),
                },
            })
                .then(() => {
                    this.setState({ addManageLoginIsOpen: false, isWorking: false, addManageLoginError: null }, () => {
                        this.getData();
                    });
                })
                .catch((addManageLoginError) => {
                    this.setState({ isWorking: false, addManageLoginError });
                });
        });
    }

    addRole() {
        this.setState({ addManageRoleIsOpen: true });
    }

    addRoleIdm() {
        this.setState({ addManageRoleIDMIsOpen: true });
    }

    updateRole(params: any) {
        this.setState({
            currentRole: params,
        }, () => {
            this.addRole();
        });
    }

    addRoleByBtn() {
        this.setState({
            currentRole: { role_id: '', deadline: '', active: '', forced: '' },
        }, () => {
            this.addRole();
        });
    }

    onChangeActive(roleInfo: IRole) {
        const action: 'deactivate' | 'activate' = roleInfo.active === '1' ? 'deactivate' : 'activate';

        this.request.exec(REQUESTS.ACTIVATE_USER_ROLE, {
            queryParams: {
                action: action,
                user_id: this.props.userId,
                role_id: roleInfo.role_id,
            },
        })
            .then(() => {
                this.setState({ changeActiveError: null });
                this.getData(true);
            })
            .catch((changeActiveError) => {
                this.setState({ changeActiveError });
            });
    }

    openRoleInfoModal(currentRoleId) {
        this.setState({ currentRoleId });
    }

    generateHrefToIDMPage(roleId) {
        return `https://idm.yandex-team.ru/system/yandex-drive-test/roles#role=${roleId},f-role-id=${roleId},f-status=all,f-role=yandex-drive-test,sort-by=-updated`;
    }

    render() {
        let templateLogins = !this.state.dataLoginsIsLoading
            ? <>
                <h3>Логины:</h3>
                {this.state.logins && this.state.logins.length
                    ? <table className={styleTable.table}>
                        <tbody>
                            <tr>
                                <th>#</th>
                                <th>Тип</th>
                                <th>Id</th>
                                <th/>
                            </tr>
                            {
                                this.state.logins && this.state.logins.map((item, index) => {
                                    return <tr key={index}>
                                        <td>{index + 1}</td>
                                        <td>{item.login_type}</td>
                                        <td>{item.login_id}</td>
                                        <td>
                                            {
                                                <Link onClick={this.removeLogin.bind(this, item)}>Удалить</Link>
                                            }
                                        </td>
                                    </tr>;
                                })
                            }
                        </tbody>
                    </table>
                    : <h4>Нет данных</h4>
                }
                <Button className={style.add_login_button}
                        basic
                        onClick={() => {
                            this.setState({ addManageLoginIsOpen: true });
                        }}>Добавить логин</Button>
                {
                    this.state.addManageLoginIsOpen
                        ? <AddLoginModal onClose={this.onClose.bind(this)}
                                         isWorking={this.state.isWorking}
                                         error={this.state.addManageLoginError}
                                         createLogin={this.addManageLoginHandle.bind(this)}/>
                        : null
                }
            </>
            : <Spin/>;
        const env: string | null = localStorage.getItem('_da_service');

        let yandexTeamUsername = this.state.userInfo
            && this.state.userInfo.setup
            && UserInfoHandler.getYandexTeamLogin.call(this.state.userInfo);
        yandexTeamUsername = yandexTeamUsername ? `${yandexTeamUsername}@` : null;

        const idmUrl = env && ['prestable', 'admin'].includes(env)
            ? `https://idm.yandex-team.ru/#rf-role=wOeM9SvD#${yandexTeamUsername}yandex-drive;;;,rf-expanded=wOeM9SvD,rf=1`
            : `https://idm.yandex-team.ru/#rf-role=wOeM9SvD#${yandexTeamUsername}yandex-drive-test;;;,rf-expanded=wOeM9SvD,rf=1`;

        let template = !this.state.dataIsLoading
            ? <>
                <h3>Роли:</h3>
                {yandexTeamUsername
                    ? <h4>
                        <Link href={idmUrl} target={'_blank'}>Роли в IDM</Link>
                    </h4>
                    : null}
                {this.state.changeActiveError
                    ? <SimpleError error={this.state.changeActiveError}
                                   data={{ label: 'Ошибка при изменении активности роли' }}/>
                    : null}
                {this.state.roles && this.state.roles.length ?
                    <table className={styleTable.table}>
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Дедлайн</th>
                                <th>Активность</th>
                                <th>forced</th>
                                <th>Id</th>
                                <th/>
                                <th>Атрибуты</th>
                                <th>Описание</th>
                                <th/>
                            </tr>
                        </thead>
                        <tbody>
                            {
                                this.state.roles && this.state.roles.map((item, index) => {
                                    const isRoleIdm = item.role_info?.role_is_idm === '1';
                                    const isActive = item.active === '1';

                                    return <tr key={index}>
                                        <td>{index + 1}</td>
                                        <td>
                                            <FormatDateAndDeadline deadline={+item.deadline}/>
                                        </td>
                                        <td className={isRoleIdm ? style.idmIcon : ''}>
                                            <Checkbox checked={isActive}
                                                      onChange={this.onChangeActive.bind(this, item)}/>
                                        </td>
                                        <td>{item?.forced?.toString()}</td>
                                        <td>{item.role_id
                                    &&
                                    <Link href={'/'}
                                          onClick={this.updateRole.bind(this,
                                              {
                                                  role_id: item.role_id,
                                                  deadline: item.deadline,
                                                  active: item.active,
                                                  forced: item.forced,
                                              },
                                          )}>{item.role_id}</Link>
                                        }
                                        </td>
                                        <td>
                                            <Link className={style.role_info}
                                                  onClick={this.openRoleInfoModal.bind(this, item.role_id)}>
                                            info
                                            </Link>
                                        </td>
                                        <td>{item.role_info?.role_groupping_tags}</td>
                                        <td>{item?.role_info?.role_description || EMPTY_DATA}</td>
                                        <td>
                                            {
                                                <Link onClick={this.removeRole.bind(this, item)}>Удалить</Link>
                                            }
                                        </td>
                                    </tr>;
                                })
                            }
                            {
                                this.state.requestedIDMRoles && this.state.requestedIDMRoles.map((item, index) => {
                                    const expireDate = item.ttl_date
                                        ? item.ttl_date
                                        : moment().add(item.ttl_days, 'days');

                                    return <tr key={index}>
                                        <td>{index + 1 + this.state.roles.length}</td>
                                        <td><FormatDate value={expireDate}/></td>
                                        <td className={style.idmIcon}>
                                        IDM роль
                                        </td>
                                        <td/>
                                        <td>{item.human_short}</td>
                                        <td/>
                                        <td/>
                                        <td>Запрошена <FormatDate value={item.added}/></td>
                                        <td>
                                            <Link href={this.generateHrefToIDMPage(item.id)}
                                                  target={'_blank'}
                                                  className={style.linkIDM}>Страница IDM
                                            </Link>
                                        </td>
                                    </tr>;
                                })
                            }
                        </tbody>
                    </table>
                    : <div>нет данных</div>
                }
                {this.props?.BlockRules?.RoleAdd && <Button className={style.add_login_button}
                                                            basic
                                                            onClick={this.addRoleByBtn.bind(this)}>
                    Добавить роль
                </Button>}

                {this.props?.BlockRules?.RoleAdd && getEnvironment() && <Button className={style.add_login_button}
                                                                                basic
                                                                                onClick={this.addRoleIdm.bind(this)}>
                    Запросить IDM роль
                </Button>}
                {
                    this.state.addManageRoleIsOpen
                    && <AddManageRole error={this.state.addManageRoleError}
                                      onClose={this.onClose.bind(this)}
                                      isWorking={this.state.isWorking}
                                      action={this.addManageRoleHandle.bind(this)}
                                      currentRole={this.state.currentRole}/>
                }
                {
                    this.state.addManageRoleIDMIsOpen
                    && <AddManageRoleIDM error={this.state.addManageRoleError}
                                         onClose={this.onClose.bind(this)}
                                         isWorking={this.state.isWorking}
                                         action={this.addManageRoleIDMHandle.bind(this)}
                                         username={this.state.userInfo.username}/>
                }
            </>
            : <Spin/>;

        !this.state.dataLoginsIsLoading && !this.state.logins && (templateLogins = <div>нет данных о ролях</div>);
        !this.state.dataIsLoading && !this.state.roles && (template = <div>нет данных о ролях</div>);

        return this.state.access && <>
            {this.state.confirmIsOpen &&
            <Confirm accept={this.state.accept.bind(this)}
                     onClose={this.onClose.bind(this)}
                     isWorking={this.state.isWorking}
                     error={this.state.error}
                     question={this.state.question}/>
            }
            {template}
            {
                this.props.BlockRules && this.props.BlockRules.teamAdm ? templateLogins : null
            }
            {
                this.props.BlockRules && this.props.BlockRules.teamAdm
                    ? <>
                        <Collapse title={'История изменений ролей'}
                                  collapsed={true}
                                  className={collapseStyles['no-padding']}>
                            <RolesHistory user_id={this.props.userId}/>
                        </Collapse>
                        <Collapse title={'Permissions'} collapsed={true}>
                            {this.state.errPerm
                            && <SimpleError data={{ label: 'Permission' }} error={this.state.errPerm}/>
                            || <ReactJson src={this.state.permissions}
                                          enableClipboard={false}/>
                            }
                        </Collapse>
                    </>
                    : null

            }
            {this.state.currentRoleId
                ? <RoleInfoModal onClose={this.openRoleInfoModal.bind(this, null)}
                                 roleId={this.state.currentRoleId}/>
                : null
            }
        </> || <div>нет доступа</div>;
    }
}

export const buildOptionsForAddUser = (options) => {
    const { user_id, role, deadline, isActive, isForced } = options;

    return {
        queryParams: {
            user_id,
        },
        body: {
            role_id: role.toString(),
            deadline: Math.floor(deadline / ONE_SECOND),
            active: isActive ? '1' : '0',
            forced: isForced,
            user_id,
        },
    };
};
