import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_USER_INFO = 'GET_USER_INFO',
    GET_USER_ROLES = 'GET_USER_ROLES',
    DELETE_USER_ROLE = 'DELETE_USER_ROLE',
    ADD_USER_ROLE = 'ADD_USER_ROLE',
    ACTIVATE_USER_ROLE = 'ACTIVATE_USER_ROLE',
    GET_USER_PERMISSIONS = 'GET_USER_PERMISSIONS',
    GET_USER_LOGINS = 'GET_USER_LOGINS',
    ADD_USER_LOGIN = 'ADD_USER_LOGIN',
    DELETE_USER_LOGIN = 'DELETE_USER_LOGIN',
    GET_ROLES = 'GET_ROLES',
    GET_ROLES_HISTORY = 'GET_ROLES_HISTORY',
    GET_ROLE = 'GET_ROLE',
    BATCH_REQUEST_IDM_ROLE = 'BATCH_REQUEST_IDM_ROLE',
    CHECK_BATCH_REQUEST_IDM_ROLE = 'CHECK_BATCH_REQUEST_IDM_ROLE',
    REQUESTED_IDM_ROLES = 'REQUESTED_IDM_ROLES',
    SINGLE_REQUEST_IDM_ROLE = 'SINGLE_REQUEST_IDM_ROLE',
}

export const CORE_DRIVE_LENS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_USER_INFO]: {
        api: 'user/report',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_USER_ROLES]: {
        api: 'user/roles/list',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.DELETE_USER_ROLE]: {
        api: 'user/roles/remove',
        cgiObj: {
            user_id: null,
            roles: null,
        },
    },
    [REQUESTS.ADD_USER_ROLE]: {
        method: REQUEST_METHOD.POST,
        api: 'user/roles/add',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.ACTIVATE_USER_ROLE]: {
        method: REQUEST_METHOD.POST,
        api: 'user/roles/${action}',
        cgiObj: {
            user_id: null,
            role_id: null,
            action: null,
        },
    },
    [REQUESTS.GET_USER_PERMISSIONS]: {
        api: 'user/permissions',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_USER_LOGINS]: {
        api: 'login/list',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.ADD_USER_LOGIN]: {
        method: REQUEST_METHOD.POST,
        api: 'login/add',
    },
    [REQUESTS.DELETE_USER_LOGIN]: {
        method: REQUEST_METHOD.POST,
        api: 'login/remove',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_ROLES]: {
        api: 'roles/list',
        cgiObj: {
            action_id: null,
            report: null,
        },
    },
    [REQUESTS.GET_ROLES_HISTORY]: {
        api: 'user/roles/history',
        cgiObj: {
            user_id: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.GET_ROLE]: {
        api: 'roles/list',
        cgiObj: {
            role_id: null,
        },
    },
    [REQUESTS.BATCH_REQUEST_IDM_ROLE]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.IDM_API,
        api: 'batchrolerequest/',
    },
    [REQUESTS.REQUESTED_IDM_ROLES]: {
        apiPrefix: API_PREFIXES.IDM_API,
        api: 'roles/',
        cgiObj: {
            user: null,
            type: null,
            system: null,
            no_meta: null,
        },
    },
    [REQUESTS.SINGLE_REQUEST_IDM_ROLE]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.IDM_API,
        api: 'rolerequests/',
    },
    [REQUESTS.CHECK_BATCH_REQUEST_IDM_ROLE]: {
        apiPrefix: API_PREFIXES.IDM_API,
        api: 'batchrolerequest/${id}/',
    },
};
