import { Dict } from '../../../../types';
import { IStore } from '../../App/store';

export interface IAddManageRoleCommon {
    onClose: () => void;
    isWorking: boolean;
    action: () => void;
    error: Error | null;
}

export interface IAddManageIDMRole extends IAddManageRoleCommon {
    username: string;
}

export interface IRoleIDMRequest {
    comment: string;
    deprive_after_days: string;
    deprive_at: string;
    user: string;
    path: string;
    user_type: string;
    sk: string;
    fields_data: Dict<any>;
    system: string;
    label: string;
    simulate?: boolean;
}

export interface IBlockRules {
    BlockRules: Dict<any>;
}

export interface IUserRolesViewProps extends IStore, IBlockRules {
    userId: string;
}

export interface ICurrentRole {
    role_id: string;
    deadline: number | string;
    active: string;
    forced?: boolean | string;
}

export interface IRole {
    active: string;
    forced?: boolean | string;
    deadline: string;
    role_id: string;
    role_description: string;
    role_info: {
        role_group: string;
        role_groupping_tags: string;
        role_id: string;
        role_is_idm: string;
        role_is_public: string;
        role_optional: string;
        role_description: string;
    };
    user_id: string;
    error?: string;
    approvers?: {full_name: string; username: string}[];
}

export interface ILogin {
    device_id: string;
    login_id: string;
    login_type: string;
    user_id: string;

}

export interface IUserRolesViewState {
    dataIsLoading: boolean;
    roles: IRole[];
    logins: ILogin[];
    confirmIsOpen: boolean;
    addManageRoleIsOpen: boolean;
    addManageRoleIDMIsOpen: boolean;
    addManageLoginIsOpen: boolean;
    dataLoginsIsLoading: boolean;
    attachTagIsOpen: boolean;
    accept: () => void;
    isWorking: boolean;
    question: string;
    currentRole: ICurrentRole;
    access: boolean;
    permissions: Dict<any>;
    errPerm: Error | null;
    userInfo: Dict<any>;
    error: Error | null;
    addManageLoginError: Error | null;
    changeActiveError: Error | null;
    addManageRoleError: Error | null;
    addManageRoleIDMError: Error | null;
    currentRoleId: string | null;
    requestedIDMRoles: any[];
}
