import * as React from 'react';

import { JsonModal } from '../../../../ui/FullModal/JsonModal';
import { Request2 } from '../../../../utils/request';
import { CLIENTS_CARD_REQUESTS, REQUESTS } from '../../request';

interface ITagEventProps {
    tagEvent: { event_id: number; type: string } | null;
    onClose: () => void;
}

interface ITagEventState {
    error: Error | null;
    isLoading: boolean;
    data: any;
}

export class TagEvent extends React.Component<ITagEventProps, ITagEventState> {
    state: ITagEventState = {
        error: null,
        isLoading: false,
        data: null,
    };

    request = new Request2({ requestConfigs: CLIENTS_CARD_REQUESTS });

    getData() {
        const { tagEvent } = this.props;

        this.request.exec(REQUESTS[`GET_${tagEvent?.type?.toUpperCase()}_TAGS_HISTORY_DETAIL`], {
            queryParams: {
                event_id: tagEvent?.event_id,
            },
        })
            .then(response => {
                this.setState({
                    data: response,
                    isLoading: false,
                });
            })
            .catch((error) => {
                this.setState({
                    isLoading: false,
                    error,
                });
            });
    }

    componentDidMount() {
        this.getData();
    }

    render() {
        const { error, data } = this.state;
        const { onClose } = this.props;

        return (
            <JsonModal onClose={onClose.bind(this)}
                       title={'Подробная информация'}
                       obj={data}
                       error={error}/>
        );
    }
}
