import * as React from 'react';
import VirtualList from 'react-tiny-virtual-list';

import { TAG_ACTION } from '../../../../types';
import { EMPTY_DATA, ONE_SECOND } from '../../../constants';
import { CarInfoHandler } from '../../../models/car';
import { UserInfoHandler } from '../../../models/user';
import FormatDate from '../../../ui/FormatDate';
import { Link } from '../../../ui/Link';
import { NoInformation } from '../../../ui/NoInformation';
import { SnapshotPhoto } from '../../CarCard/CarTagsView/SnapshotPhoto';
import CarNumber from '../../CarNumber';
import styles from './index.css';
import TagEvent from './TagEvent';

export const HistoryTags = React.memo((props: { history: any; timelapse: string; label: string }) => {
    const { history, timelapse, label } = props;
    const [tagEvent, setTagEvent] = React.useState<{ event_id: number; type: string } | null>(null);
    const [eventId, setEventId] = React.useState('');

    return (
        <>
            {tagEvent !== null &&
            <TagEvent tagEvent={tagEvent}
                      onClose={setTagEvent.bind(null, null)}/>
            }
            {
                eventId
                && <SnapshotPhoto eventId={eventId} onClose={setEventId.bind(null, '')}/>
            }
            <h4 className={'title'}>История тегов {label} c {timelapse}</h4>
            {history.length
                ? <div className={styles.historyTable}>
                    <div className={`${styles.header} ${styles.row}`}>
                        <span>#</span>
                        <span>Дата</span>
                        <span>Действие</span>
                        <span/>
                        <span>Тег</span>
                        <span/>
                        <span/>
                    </div>
                    <VirtualList width={'100%'}
                                 height={250}
                                 itemCount={history.length}
                                 itemSize={35}
                                 renderItem={({ index, style }) => {
                                     const item = history?.[index];
                                     const car_model = CarInfoHandler.getModelName.call(item?.car || {}) || {};

                                     return (
                                         <div key={index}
                                              style={style}
                                              className={styles.row}>
                                             <span>{index + 1}</span>
                                             <span>
                                                 <FormatDate value={item.timestamp * ONE_SECOND}
                                                             withSecond/>
                                             </span>
                                             <span>
                                                 {item.event_id &&
                                        <div>
                                            <Link onClick={setTagEvent.bind(null,
                                                {
                                                    event_id: item.event_id,
                                                    type: item?.car ? 'car' : 'user',
                                                })}>
                                                {item.action}
                                            </Link>
                                        </div>
                                        || <div>{item.action}</div>
                                                 }
                                             </span>
                                             <span>
                                                 {
                                                     item.action === TAG_ACTION.ADD_SNAPSHOT
                                                         ? <span className={'show-photo'}
                                                                 onClick={setEventId.bind(null, item.event_id)}>📷</span>
                                                         : ''
                                                 }
                                             </span>
                                             <span>{item.tag_name || EMPTY_DATA}</span>
                                             <span>{item.car && item.car.number &&
                                    <CarNumber carInfo={item.car}/> || ''}</span>
                                             <span>
                                                 {item?.car?.id &&
                                        <Link href={`#/cars/${item.car.id}/tags`}
                                              title={item.car.id}
                                              className={styles.model}
                                              target={'_blank'}>
                                            {car_model ?? EMPTY_DATA}
                                        </Link>}
                                                 {
                                                     item?.user &&
                                            <Link target={'_blank'}
                                                  href={`#/clients/${item.user.id}/info-old`}>
                                                {UserInfoHandler.getPrintName.call(item.user)}
                                            </Link>
                                                 }
                                             </span>
                                         </div>
                                     );
                                 }}/>
                </div>
                : <NoInformation/>}
        </>
    );
});
