import * as React from 'react';

import { UserInfoHandler } from '../../../models/user';
import { Link } from '../../../ui/Link';
import { NoInformation } from '../../../ui/NoInformation';
import * as tblStyles from '../../../ui/Table/index.css';
import CarNumber from '../../CarNumber';
import styles from './index.css';

export const PerformTags = React.memo((props: { perform: any; label: string }) => {
    const { perform, label } = props;
    const back = encodeURIComponent(location.hash);

    return <div className={styles.perform}>
        <h4>Теги {label} в работе</h4>
        {perform?.length
            ? (
                <table className={`${tblStyles.table} ${styles.performTable}`}>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>приоритет</th>
                            <th>тег</th>
                            <th>комментарий</th>
                            <th/>
                            <th/>
                        </tr>
                    </thead>
                    <tbody>
                        {
                            perform.map((_el: any, key: number) => {
                                return (
                                    <tr key={key}>
                                        <td>{key + 1}</td>
                                        <td>{_el.priority}</td>
                                        <td>
                                            <div><strong>{_el.display_name}</strong></div>
                                            <div>{_el.tag}</div>
                                        </td>
                                        <td className={styles.comment}>{_el.comment}</td>
                                        <td>
                                            {_el?.object_info?.number && <CarNumber value={_el.object_info.number}/>}
                                        </td>
                                        <td>
                                            {_el?.object_info?.model_id &&
                                        <Link target={'_blank'}
                                              href={`#/cars/${_el.object_info.id}/tags?back=${back}`}>
                                            {_el.object_info.model_id}
                                        </Link>}
                                            {
                                                _el?.object_info?.hasOwnProperty('username') &&
                                            <Link target={'_blank'}
                                                  href={`#/clients/${_el.object_info.id}/info-old?back=${back}`}>
                                                {UserInfoHandler.getPrintName.call(_el.object_info)}
                                            </Link>
                                            }
                                        </td>
                                    </tr>
                                );
                            })
                        }
                    </tbody>
                </table>
            )
            : <NoInformation/>
        }
    </div>;
});
