import * as React from 'react';
import Scrollbars from 'react-custom-scrollbars';
import ReactTooltip from 'react-tooltip';

import { OLD_SESSION_TAB_ID, ONE_SECOND, SESSION_TAB_ID } from '../../constants';
import { UserInfoHandler } from '../../models/user';
import { CopyIcon } from '../../ui/CopyIcon';
import FormatDate from '../../ui/FormatDate';
import * as coreStyle from '../../ui/index.css';
import { Request2 } from '../../utils/request';
import { TabView } from '../../utils/TabView';
import { Translate } from '../../utils/translate';
import { parseUA, setDocumentTitle } from '../../utils/utils';
import { VisitedLog } from '../Content/db';
import { Copy } from '../Copy';
import { SimpleError } from '../SimpleError';
import Spin from '../Spin';
import Achievements2 from './Achievements2';
import { UserInfoContext } from './context';
import * as style from './index.css';
import { CLIENTS_CARD_REQUESTS as requestConfigs, REQUESTS } from './request';
import UserCardSidebar from './UserCardSidebar';

export default class Clients extends React.Component<any, any> {
    render() {
        return (
            <>
                {this.props.userId
                    ? <UserCard {...this.props} /> : null
                    /*: <ClientsView/>*/
                }
            </>
        );
    }
}

export class UserCard extends React.Component<any, any> {
    state = {
        userInfo: {},
        userLoadingError: null,
        isLoading: false,
    };
    request = new Request2({
        requestConfigs,
    });
    t = this.props.Lang && new Translate(this.props.Lang) || {} as Translate;
    visitedLog = new VisitedLog();

    componentDidMount(): void {
        this.getUserInfo();
    }

    componentDidUpdate(prevProps): void {
        const prevUserId = prevProps && prevProps.match
            && prevProps.match.params && prevProps.match.params.client_id || '';
        const userId = this.props && this.props.match
            && this.props.match.params && this.props.match.params.client_id || '';

        if (userId !== prevUserId) {
            this.getUserInfo();
        }
    }

    getUserInfo() {
        this.setState({ isLoading: true }, () => {

            const params = this.props && this.props.match && this.props.match.params || {};
            const { client_id: user_id = '' } = params;

            this.request.exec(REQUESTS.GET_USER_INFO, { queryParams: { user_id } })
                .then(response => {
                    setDocumentTitle(UserInfoHandler.getShortPrintName.call(response));
                    this.setState({ userInfo: response, isLoading: false, userLoadingError: null }, () => {
                        this.visitedLog.saveLog(this.state.userInfo, this.props);
                    });
                })
                .catch(userLoadingError => {
                    this.setState({ isLoading: false, userLoadingError });
                });
        });
    }

    render() {
        if (this.state.userLoadingError) {
            return <SimpleError error={this.state.userLoadingError}
                                data={{ label: 'Ошибка при загрузке данных пользователя' }}/>;
        }

        const props: any = this.props;
        const userInfo: any = this.state.userInfo;

        const ua = userInfo
            && userInfo.realtime_data
            && userInfo.realtime_data.user_agent
            && parseUA(userInfo.realtime_data.user_agent);

        const isSession2Tab = this.props?.match?.params?.tabId === SESSION_TAB_ID
            || (this.props?.match?.params?.tabId === OLD_SESSION_TAB_ID && this.props?.blockRules?.NewSessionList);

        return <div className={`${coreStyle.card} ${style.user_card}`}>
            <div className={coreStyle.header}>
                <div className={style.user_name}>
                    {this.state.isLoading
                        ? <Spin size={'l'}/>
                        : <>
                            <Copy text={location.href}
                                  internalTooltipId={'copy_location'}>
                                <span>↗️</span>
                            </Copy>
                            <CopyIcon text={userInfo && userInfo.id}
                                      title={'Скопировать ID в буфер'}
                                      internalTooltipId={'copy_user_id'}/>
                            <h2>
                                <Copy text={UserInfoHandler.getPrintName.call(userInfo)}
                                      internalTooltipId={'copy_user_name'}>
                                    {UserInfoHandler.getPrintName.call(userInfo)}
                                </Copy>
                            </h2>
                            {ua && <div className={style.device}>
                                <Copy text={`${ua.device};v${ua.version}`}
                                      internalTooltipId={'user_device'}>
                                    <div data-tip className={style.user_header_debt} data-for={'1'}>
                                        Устройство: {ua && <strong>{ua.device}</strong>} / {ua.version}
                                    </div>
                                    <ReactTooltip id={'1'}
                                                  aria-haspopup='true'
                                                  place={'bottom'}
                                                  type="info"
                                                  className={style.custom_tooltip}
                                                  effect="solid">
                                        <div>
                                            <div>
                                                host: <strong>{userInfo && userInfo.realtime_data
                                            && userInfo.realtime_data.host}</strong>
                                            </div>
                                            <div>
                                                user_agent: <strong>{userInfo && userInfo.realtime_data
                                            && userInfo.realtime_data.user_agent}</strong>
                                            </div>
                                            <div>device_id: <strong>{userInfo && userInfo.realtime_data
                                            && userInfo.realtime_data.device_id}</strong>
                                            </div>
                                            <strong><FormatDate value={userInfo && userInfo.realtime_data
                                                && userInfo.realtime_data.last_data_update * ONE_SECOND}
                                                                withSecond/>
                                            </strong>
                                        </div>
                                    </ReactTooltip>
                                </Copy>
                            </div>}
                        </>}

                </div>
                <div className={style.achievements}>
                    <Achievements2 user_id={userInfo.id}
                                   plus={userInfo && userInfo.blackbox && userInfo.blackbox.plus}
                                   ya={userInfo && userInfo.blackbox && userInfo.blackbox.yandexoid}
                                   vip={userInfo && userInfo.call_priority_user}/>
                </div>
            </div>
            <div className={coreStyle.tabs}>
                <TabView withoutTitle {...props}/>
            </div>
            <div className={coreStyle.sidebar}>
                <UserCardSidebar userInfo={userInfo} isLoading={this.state.isLoading}/>
            </div>
            {
                isSession2Tab
                    ? <div className={`${coreStyle.content} ${coreStyle.session_content}`}>
                        {this.props.children}
                    </div>
                    : <div className={coreStyle.content}>
                        <UserInfoContext.Provider value={this.state.userInfo}>
                            <Scrollbars style={{ maxHeight: 'calc(100vh - 80px)' }} autoHide>
                                {this.props.children}
                            </Scrollbars>
                        </UserInfoContext.Provider>
                    </div>
            }

        </div>;
    }
}
