import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    GET_USER_INFO = 'GET_USER_INFO',
    GET_USER_ACTIONS = 'GET_USER_ACTIONS',

    GET_ACCOUNTS = 'GET_ACCOUNTS',
    LINK_WALLET_USER = 'LINK_WALLET_USER',
    GET_WALLETS_DESCRIPTIONS = 'GET_WALLETS_DESCRIPTIONS',
    ACTIVATE_ACCOUNT = 'ACTIVATE_ACCOUNT',
    GET_BILLING_INFO = 'GET_BILLING_INFO',
    GET_USER_SESSIONS = 'GET_USER_SESSIONS',
    GET_TAGS_HISTORY = 'GET_TAGS_HISTORY',
    GET_TAG_DESCRIPTIONS = 'GET_TAG_DESCRIPTIONS',
    CANCEL_PAYMENT = 'CANCEL_PAYMENT',
    GET_CARDS_TRUST = 'GET_CARDS_TRUST',
    FORCE_PAYMENT = 'FORCE_PAYMENT',
    GET_PROMO_HISTORY = 'GET_PROMO_HISTORY',
    GET_PROMO_HISTORY_BY_CODE = 'GET_PROMO_HISTORY_BY_CODE',
    ATTACH_USER_TAG = 'ATTACH_USER_TAG',
    GET_WALLET = 'GET_WALLET',
    APPROVE_USERS_PHOTO = 'APPROVE_USERS_PHOTO',
    GET_USER_DEVICES = 'GET_USER_DEVICES',
    ENABLE_DEVICE = 'ENABLE_DEVICE',
    VERIFY_DEVICE = 'VERIFY_DEVICE',
    REMOVE_DEVICE = 'REMOVE_DEVICE',
    REGISTER_USER = 'REGISTER_USER',
    CHECK_AUTO_CODE = 'CHECK_AUTO_CODE',
    PHONE_HISTORY = 'PHONE_HISTORY',
    EDIT_USER = 'EDIT_USER',
    GET_USER_TAGS = 'GET_USER_TAGS',
    GET_TAG_SEARCH = 'GET_TAG_SEARCH',
    GET_USER_TAGS_BY_PERFORMER = 'GET_USER_TAGS_BY_PERFORMER',
    GET_USER_TAGS_HISTORY = 'GET_USER_TAGS_HISTORY',
    GET_CAR_TAGS_HISTORY_DETAIL = 'GET_CAR_TAGS_HISTORY_DETAIL',
    GET_USER_TAGS_HISTORY_DETAIL = 'GET_USER_TAGS_HISTORY_DETAIL',
    GET_STAFF = 'GET_STAFF',
    GET_TAGS = 'GET_TAGS',
    GET_SESSIONS_CURRENT = 'GET_SESSIONS_CURRENT',
    GET_SCORING_SETTINGS = 'GET_SCORING_SETTINGS',
    GET_USER_FEATURES = 'GET_USER_FEATURES',

    GET_USER_DOC_DATA = 'GET_USER_DOC_DATA',
    SEARCH = 'SEARCH',
}

export const CLIENTS_CARD_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_TAGS]: {
        api: 'tag/description/list',
    },
    [REQUESTS.PHONE_HISTORY]: {
        api: 'user/phone/history',
        cgiObj: {
            user_id: null,
        },
    }, [REQUESTS.EDIT_USER]: {
        method: REQUEST_METHOD.POST,
        api: 'user/edit',
    },
    [REQUESTS.GET_USER_INFO]: {
        api: 'user/info',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_USER_ACTIONS]: {
        api: 'user/actions/list',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_ACCOUNTS]: {
        api: 'billing/accounts',
        cgiObj: {
            user_id: null,
            account_name: null,
            from: null,
        },
    },
    [REQUESTS.LINK_WALLET_USER]: {
        api: 'billing/accounts/link',
        method: REQUEST_METHOD.POST,
        cgiObj: {
            account_id: null,
            action: null,
            active_flag: null,
            force: null,
            name: null,
            user_id: null,
        },
    },
    [REQUESTS.GET_WALLETS_DESCRIPTIONS]: {
        api: 'billing/accounts/descriptions',
    },
    [REQUESTS.ACTIVATE_ACCOUNT]: {
        method: REQUEST_METHOD.POST,
        api: 'billing/accounts/activate',
    },
    [REQUESTS.GET_BILLING_INFO]: {
        api: 'billing/payment/info',
        cgiObj: {
            user_id: null,
            details: 'yes',
            since: null,
            until: null,
        },
    },
    [REQUESTS.GET_USER_SESSIONS]: {
        api: 'sessions/history',
        cgiObj: {
            numdoc: null,
            user_id: null,
        },
    },
    [REQUESTS.GET_TAGS_HISTORY]: {
        api: 'users/tags_history',
        cgiObj: {
            object_id: null,
            since: null,
            until: null,
            duration: null,
        },
    },
    [REQUESTS.GET_TAG_DESCRIPTIONS]: {
        api: 'tag/description/list',
    },
    [REQUESTS.ATTACH_USER_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'user_tags/add',
    },
    [REQUESTS.CANCEL_PAYMENT]: {
        method: REQUEST_METHOD.POST,
        api: 'billing/payment/cancel',
    },
    [REQUESTS.GET_CARDS_TRUST]: {
        api: 'billing/trust',
        cgiObj: {
            user_id: null,
            cards_only: null,
        },
    },
    [REQUESTS.FORCE_PAYMENT]: {
        method: REQUEST_METHOD.POST,
        api: 'billing/payment/reset',
    },
    [REQUESTS.GET_PROMO_HISTORY]: {
        api: 'promo/user_history',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_PROMO_HISTORY_BY_CODE]: {
        api: 'promo/check',
        cgiObj: {
            code: null,
            usage_history: 'da',
        },
    },
    [REQUESTS.GET_WALLET]: {
        api: 'billing/accounts',
        cgiObj: {
            account_id: null,
            account_name: null,
            numdoc: null,
            from: null,
            user_id: null,
        },
    },
    [REQUESTS.APPROVE_USERS_PHOTO]: {
        api: 'user/photo/approve',
        cgiObj: {
            photo_id: null,
        },
    },
    [REQUESTS.GET_USER_DEVICES]: {
        api: 'devices/list',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.ENABLE_DEVICE]: {
        api: 'devices/control',
        cgiObj: {
            devices: null,
            enabled: null,
            user_id: null,
        },
    },
    [REQUESTS.VERIFY_DEVICE]: {
        api: 'devices/control',
        cgiObj: {
            devices: null,
            verified: null,
            user_id: null,
        },
    },
    [REQUESTS.REMOVE_DEVICE]: {
        api: 'devices/remove',
        cgiObj: {
            devices: null,
            user_id: null,
        },
    },
    [REQUESTS.REGISTER_USER]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'user/register-force',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.CHECK_AUTO_CODE]: {
        api: 'user/check_driver_license/',
        cgiObj: {
            license_number: null,
            issue_date: null,
        },
    },
    [REQUESTS.GET_USER_TAGS]: {
        api: 'user_tags/list',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.GET_USER_TAGS_BY_PERFORMER]: {
        api: 'tags/by_performer',
        cgiObj: {
            performer: null,
        },
    },
    [REQUESTS.GET_USER_TAGS_HISTORY]: {
        api: 'user/tags_history',
        cgiObj: {
            user_id: null,
            since: null,
            until: null,
            duration: null,
            timeout: '120000000',
        },
    },
    [REQUESTS.GET_CAR_TAGS_HISTORY_DETAIL]: {
        api: 'car/tag/history/details',
        cgiObj: {
            event_id: null,
        },
    },
    [REQUESTS.GET_USER_TAGS_HISTORY_DETAIL]: {
        api: 'user/tag/history/details',
        cgiObj: {
            event_id: null,
        },
    },
    [REQUESTS.GET_TAG_SEARCH]: {
        api: 'tags/search',
        cgiObj: {
            has_all_of: null,
            has_none_of: null,
            has_one_of: null,
            limit: null,
            performer_id: null,
        },
    },
    [REQUESTS.GET_STAFF]: {
        api: 'hierarchy/get',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_SESSIONS_CURRENT]: {
        api: 'sessions/current',
        cgiObj: {
            user_id: null,
            traits: null,
        },
    },
    [REQUESTS.GET_SCORING_SETTINGS]: {
        api: 'settings/info',
        cgiObj: {
            prefix: 'aggression',
        },
    },
    [REQUESTS.GET_USER_FEATURES]: {
        api: 'user/features',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_USER_DOC_DATA]: {
        api: 'user/document_data',
        cgiObj: {
            user_id: null,
            photo_id: null,
            background_video: null,
        },
    },
    [REQUESTS.SEARCH]: {
        api: 'search',
        cgiObj: {
            has_all_of: null,
            limit: null,
        },
    },
};
