import React from 'react';

import { Button, ButtonTypes } from '../../ui/Button';
import { Window } from '../../ui/FullModal';
import * as coreStyle from '../../ui/index.css';
import { Request2 } from '../../utils/request';
import { REQUESTS as REQUESTS2, SETTINGS_REQUESTS } from '../Settings/request';
import { SimpleError } from '../SimpleError';
import Spin from '../Spin';
import * as style from './index.css';

enum ACTION {
    CONFIRM = 'confirm',
    REJECT = 'reject',
}

export class ConfirmModal extends React.Component<any> {
    state = {
        actions: [], roles: [], polygons: [], landings: [],
        actionsIsLoading: false, rolesIsLoading: false, polygonsIsLoading: false, landingsIsLoading: false,
        actionsError: null, rolesError: null, polygonsError: null, landingsError: null,
    };
    request = new Request2({ requestConfigs: SETTINGS_REQUESTS });

    getCheckedData(name) {
        return this.props[`${name}`].filter((el) => {
            return this.props[`checked_${name}`][el.proposition_id];
        });
    }

    componentDidMount(): void {
        this.setState({
            actions: this.getCheckedData('actions'),
            roles: this.getCheckedData('roles'),
            polygons: this.getCheckedData('polygons'),
            landings: this.getCheckedData('landings'),
        });
    }

    callback() {
        if (!this.state.actionsError && !this.state.rolesError
            && !this.state.polygonsError && !this.state.landingsError) {
            this.props.onClose();
            this.props.update();
        }
    }

    action(action: ACTION) {
        const state = {
            ...this.state.actions.length && { actionsIsLoading: true },
            ...this.state.roles.length && { rolesIsLoading: true },
            ...this.state.polygons.length && { polygonsIsLoading: true },
            ...this.state.landings.length && { landingsIsLoading: true },
            actionsError: null, rolesError: null, polygonsError: null, landingsError: null,
        };
        this.setState((prev) => {
            return { ...prev, ...state };
        }, () => {

            this.state.roles.length && this.request.exec(REQUESTS2[`ROLES_SNAPSHOT_${action.toUpperCase()}`], {
                body: { proposition_ids: this.state.roles.map((a: any) => a.proposition_id) },
            })
                .then(() => {
                    this.setState((prev) => ({
                        ...prev,
                        rolesIsLoading: false,
                        rolesError: null,
                        roles: [],
                    }), () => {
                        this.callback();
                    });

                })
                .catch((rolesError) => {
                    this.setState((prev) => ({
                        ...prev,
                        rolesIsLoading: false,
                        rolesError,
                    }));
                });

            this.state.polygons.length && this.request.exec(REQUESTS2[`AREA_${action.toUpperCase()}`], {
                queryParams: { comment: `confirmed at ${new Date().getTime()}` },
                body: { proposition_ids: this.state.polygons.map((a: any) => a.proposition_id) },
            })
                .then(() => {
                    this.setState((prev) => ({
                        ...prev,
                        polygonsIsLoading: false,
                        polygonsError: null,
                        polygons: [],
                    }), () => {
                        this.callback();
                    });

                })
                .catch((polygonsError) => {
                    this.setState((prev) => ({
                        ...prev,
                        polygonsIsLoading: false,
                        polygonsError,
                    }));
                });

            this.state.landings.length && this.request.exec(REQUESTS2[`LANDING_${action.toUpperCase()}`], {
                queryParams: { comment: `confirmed at ${new Date().getTime()}` },
                body: { proposition_ids: this.state.landings.map((a: any) => a.proposition_id) },
            })
                .then(() => {
                    this.setState((prev) => ({
                        ...prev,
                        landingsIsLoading: false,
                        landingsError: null,
                        landings: [],
                    }), () => {
                        this.callback();
                    });

                })
                .catch((landingsError) => {
                    this.setState((prev) => ({
                        ...prev,
                        landingsIsLoading: false,
                        landingsError,
                    }));
                });

            this.state.actions.length && this.request.exec(REQUESTS2[`ACTION_${action.toUpperCase()}`], {
                body: { proposition_ids: this.state.actions.map((a: any) => a.proposition_id) },
            })
                .then(() => {
                    this.setState((prev) => ({
                        ...prev,
                        actionsIsLoading: false,
                        actionsError: null,
                        actions: [],
                    }), () => {
                        this.callback();
                    });

                })
                .catch((actionsError) => {
                    this.setState((prev) => ({
                        ...prev,
                        actionsIsLoading: false,
                        actionsError,
                    }));
                });
        });
    }

    render() {
        const isLoading = this.state.actionsIsLoading || this.state.rolesIsLoading || this.state.polygonsIsLoading;

        return <Window onClose={this.props.onClose.bind(this)} title={'Подтверждение заявок'}>
            <div className={style.modal_content}>
                <div className={`${style.item} ${!this.state.actions.length ? style.empty : ''}`}>
                    Экшены: {this.state.actions.length} {this.state.actionsIsLoading && <Spin size={'s'}/>}</div>
                <div className={style.item_id_elements}>
                    {this.state.actions.map((item: any, index) => {
                        return <span key={`actions_${index}`}>{item.action_id}, </span>;
                    })}
                </div>
                <div className={style.error}>
                    {this.state.actionsError && <SimpleError error={this.state.actionsError}/>}
                </div>
                <div className={`${style.item} ${!this.state.roles.length ? style.empty : ''}`}>
                    Роли: {this.state.roles.length} {this.state.rolesIsLoading && <Spin size={'s'}/>}</div>
                <div className={style.item_id_elements}>
                    {this.state.roles.map((item: any, index) => <span key={`roles_${index}`}>{item.role_id}, </span>)}
                </div>
                <div className={style.error}>
                    {this.state.rolesError && <SimpleError error={this.state.rolesError}/>}
                </div>
                <div className={`${style.item} ${!this.state.polygons.length ? style.empty : ''}`}>
                    Полигоны: {this.state.polygons.length} {this.state.polygonsIsLoading && <Spin size={'s'}/>}</div>
                <div className={style.item_id_elements}>
                    {this.state.polygons.map((item: any, index) => {
                        return <span key={`polygons_${index}`}>{item.area_id}, </span>;
                    })}
                </div>
                <div className={style.error}>
                    {this.state.polygonsError && <SimpleError error={this.state.polygonsError}/>}
                </div>
                {/*--------*/}
                <div className={`${style.item} ${!this.state.landings.length ? style.empty : ''}`}>
                    Интроскрины: {this.state.landings.length} {this.state.landingsIsLoading && <Spin size={'s'}/>}</div>
                <div className={style.item_id_elements}>
                    {this.state.landings.map((item: any, index) => {
                        return <span key={`landings_${index}`}>{item.landing_id}, </span>;
                    })}
                </div>
                <div className={style.error}>
                    {this.state.landingsError && <SimpleError error={this.state.landingsError}/>}
                </div>
            </div>
            <div className={`${coreStyle.button_container} ${coreStyle.full_width}`}>
                <Button onClick={this.props.onClose.bind(this)}
                        isLoading={isLoading}>Закрыть</Button>
                <Button colorType={ButtonTypes.negative}
                        onClick={this.action.bind(this, ACTION.REJECT)}
                        isLoading={isLoading}>Отклонить</Button>
                <Button colorType={ButtonTypes.positive}
                        onClick={this.action.bind(this, ACTION.CONFIRM)}
                        isLoading={isLoading}>Подтвердить</Button>
            </div>
        </Window>;
    }
}
