import React from 'react';

import { Dict } from '../../../types';
import { ONE_SECOND } from '../../constants';
import { UserInfoHandler } from '../../models/user';
import Checkbox from '../../ui/Checkbox';
import FormatDate, { dateLag } from '../../ui/FormatDate';
import { Link } from '../../ui/Link';
import * as tblStyle from '../../ui/Table/index.css';
import { NAVIGATION } from '../../utils/navigation';
import { DiffLabel } from '../DiffLabel/component';
import * as style from './index.css';

interface ITableData {
    data: any[];
    report: any[];
    idKey: string;
    checked: Dict<boolean>;
    onChange: (proposition_id:string) => void;
    filters: Dict<any>;
}

const EXCLUDE_OFFERS_FIELDS = ['__author', 'confirmators', 'proposition_author'
    , 'confirmations_count', 'confirmations', 'parent', 'propositions', 'proposition_description'
    , 'proposition_id', 'confirmations_need'];

export const Table = (props: ITableData) => {
    return <table className={`${tblStyle.table} ${style.table}`}>
        <Head/>
        <Body {...props}/>
    </table>;
};

const Head = () => {
    return <thead>
        <tr>
            <th>#</th>
            <th>freshness</th>
            <th>history_instant/user</th>
            <th/>
            <th>id/description</th>
            <th>diff</th>
        </tr>
    </thead>;
};

const Body = (props: ITableData) => {
    const { data = [], idKey, checked, onChange, report = {}, filters } = props;
    const setFilter = (description) => {
        location.hash = `${NAVIGATION.ROUTES?.CONFIRMATIONS?.uri}?description=${encodeURIComponent(description)}`;
    };

    return <tbody>
        {data.filter((el => {
            return !filters.description || el.proposition_description?.includes(filters.description);
        })).map((item: any, index) => {
            const userId = UserInfoHandler.getId.call(item.__author);
            const userName = UserInfoHandler.getPrintNameWithoutPn.call(item.__author);
            const history_instant = item.confirmations
                && item.confirmations[0]
                && item.confirmations[0].history_instant;
            const lag = dateLag(history_instant * ONE_SECOND);
            const isOld = lag.includes('дн.');

            return <tr key={index}>
                <td className={style.index}>{index + 1}</td>
                <td className={style.chb}>
                    <Checkbox checked={checked[item.proposition_id]}
                              onChange={onChange.bind(null, item.proposition_id)}/>
                </td>
                <td className={style.date}>{history_instant
            && <FormatDate value={history_instant * ONE_SECOND} withSecond/>}
                {userId
                && <div>
                    <Link href={`#/clients/${userId}`}>{userName}</Link>
                </div>}
                </td>
                <td className={`${style.lag} ${isOld ? style.old : ''}`}>{lag}</td>
                <td className={style.description}>
                    <div><strong>{item[idKey]}</strong></div>
                    <div><Link onClick={setFilter.bind(null, item.proposition_description)}>
                        <i>{item.proposition_description}</i>
                    </Link></div>
                </td>
                <td className={style.diff_place}><DiffLabel child={item}
                                                            className={style.diff_labels}
                                                            parent={report[item[idKey]]}
                                                            maxCount={3}
                                                            exclude={EXCLUDE_OFFERS_FIELDS}/>...
                </td>
            </tr>;
        })}
    </tbody>;
};
