import React from 'react';

import { Button, ButtonTypes } from '../../ui/Button';
import Checkbox from '../../ui/Checkbox';
import { Link } from '../../ui/Link';
import { NAVIGATION } from '../../utils/navigation';
import { Request2 } from '../../utils/request';
import { deepCopy } from '../../utils/utils';
import { SimpleError } from '../SimpleError';
import Spin from '../Spin';
import { ConfirmModal } from './ConfirmationModal';
import { Table } from './ConfirmationTable';
import * as style from './index.css';
import { CONFIRM_REQUEST, REQUESTS } from './request';

export class Confirmations extends React.Component<any, any> {
    state = {
        actionsIsLoading: false,
        rolesIsLoading: false,
        polygonsIsLoading: false,
        landingsIsLoading: false,

        actions: [],
        roles: [],
        polygons: [],
        landings: [],

        actions_report: [],
        roles_report: [],
        polygons_report: [],
        landings_report: [],

        checked_actions: {},
        checked_roles: {},
        checked_polygons: {},
        checked_landings: {},

        actionsError: null,
        rolesError: null,
        polygonsError: null,
        landingsError: null,

        confirmIsShowing: false,
        description: "",
    };

    request = new Request2({ requestConfigs: CONFIRM_REQUEST });

    componentDidMount(): void {
        this.getData();
        this.setParams();
    }

    setParams() {
        const params = new URLSearchParams(this.props?.location?.search);
        this.setState({
            description: params.get("description"),
        });
    }

    componentDidUpdate(prevProps) {
        if (this.props?.location?.search !== prevProps?.location?.search) {
            this.setParams();
        }
    }

    sortComparator(a, b) {
        return a.confirmations && a.confirmations[0] && b.confirmations && b.confirmations[0]
      && a.confirmations[0].history_instant - b.confirmations[0].history_instant;
    }

    [`actionsHandle`](_data) {
        const _obj = _data && _data.report && _data.report.reduce((_p, _c) => {
            if (_c.hasOwnProperty("propositions") && _c.propositions.length) {
                _p.report[_c.action_id] = _c;
                const data = _c.propositions.map(item => {
                    const user_id = item.proposition_author;

                    const author = _data?.proposition_users
            && Array.isArray(_data.proposition_users)
            && _data.proposition_users.find(user => user.id === user_id);

                    return Object.assign({}, item, { __author: author });
                });
                _p.data.push(...data);
            }

            return _p;
        }, { data: [], report: {} });

        return [_obj.data.sort(this.sortComparator), _obj.report];
    }

    [`rolesHandle`](data) {
        return this.commonHandle(data, "report", "role_id");
    }

    [`polygonsHandle`](data) {
        return this.commonHandle(data, "areas", "area_id");
    }

    [`landingsHandle`](data) {
        return this.commonHandle(data, "landings", "landing_id");
    }

    commonHandle(_data, _parents, key) {
        const parentsObject = (_data[_parents] || []).reduce((_p, _c) => {
            if (!_p.hasOwnProperty(_c[key])) {
                _p[_c[key]] = _c;
            }

            return _p;
        }, {});
        const data = _data && _data.propositions && _data.propositions.map(item => {
            const user_id = item.proposition_author;
            item.__author = _data?.users?.[user_id] || {};

            return item;
        }).sort(this.sortComparator) || [];

        const report = data.reduce((_p, _c) => {
            if (!_p.hasOwnProperty(_c[key])) {
                _p[_c[key]] = parentsObject[_c[key]];
            }

            return _p;
        }, {});

        return [data, report];
    }

    getEntities(name) {
        this.setState({
            [`${name}IsLoading`]: true,
        }, () => {
            this.request.exec(REQUESTS[`GET_${name.toUpperCase()}`])
                .then(response => {
                    const [data, report] = this[`${name}Handle`] && this[`${name}Handle`](response);
                    this.setState({
                        [`${name}IsLoading`]: false,
                        [`${name}`]: data,
                        [`${name}_report`]: report,
                        [`checked_${name}`]: data.reduce((_p, _c) => {
                            if (!_p.hasOwnProperty(_c.proposition_id)) {
                                _p[_c.proposition_id] = false;
                            }

                            return _p;
                        }, {}),
                        [`${name}Error`]: null,
                    });
                })
                .catch(error => {
                    this.setState({
                        [`${name}IsLoading`]: false,
                        [`${name}Error`]: error,
                    });
                });
        });
    }

    getData() {
        Promise.all([
            this.getEntities("roles"),
            this.getEntities("actions"),
            this.getEntities("polygons"),
            this.getEntities("landings")],
        ).then(() => {
            this.setParams();
        });
    }

    checkedHandle(field, id, value) {
        this.setState((prevState) => {
            prevState[`checked_${field}`][id] = value;

            return {
                ...prevState,
            };
        });
    }

    globalChange(field, value) {
        const propositions_obj: any[] = deepCopy(this.state[field]).reduce((_p, _c) => {
            if (!_p.hasOwnProperty(_c.proposition_id)) {
                if (!this.state.description || _c.proposition_description.includes(this.state.description)) {
                    _p[_c.proposition_id] = value;
                } else {
                    _p[_c.proposition_id] = false;
                }
            }

            return _p;
        }, {});

        this.setState({
            [`checked_${field}`]: propositions_obj,
        });
    }

    confirm(state: boolean) {
        this.setState({
            confirmIsShowing: state,
        });
    }

    clearFilters() {
        location.hash = NAVIGATION.ROUTES?.CONFIRMATIONS?.uri;
    }

    render() {
        const confirmIsEnabled = Object.entries({
            ...this.state.checked_actions,
            ...this.state.checked_roles,
            ...this.state.checked_polygons,
            ...this.state.checked_landings,
        }).filter(el => el[1]);

        return <div className={style.component}>
            {
                this.state.confirmIsShowing
        && <ConfirmModal {...this.state}
                         update={this.getData.bind(this)}
                         onClose={this.confirm.bind(this, false)} />
            }
            <h2>Заявки <Button colorType={ButtonTypes.positive}
                               onClick={this.confirm.bind(this, true)}
                               disabled={!confirmIsEnabled.length}>
        Подтвердить/Отклонить ({confirmIsEnabled.length})
            </Button>
            </h2>
            {this.state.description ? <div>
          Фильтры: <strong>description: </strong> <span><i>{this.state.description}</i> </span>
                <Link onClick={this.clearFilters.bind(this)}>сбросить фильтры</Link>
            </div>
                : ""
            }
            {/*---------------------Экшены------------------*/}

            <PropositionSection label={`Экшены`}
                                entity={"actions"}
                                idKey={`action_id`}
                                globalChange={this.globalChange.bind(this)}
                                description={this.state.description}
                                onChange={this.checkedHandle.bind(this)}
                                state={this.state}/>
            {/*---------------------Роли------------------*/}

            <PropositionSection label={`Роли`}
                                entity={"roles"}
                                idKey={`role_id`}
                                globalChange={this.globalChange.bind(this)}
                                description={this.state.description}
                                onChange={this.checkedHandle.bind(this)}
                                state={this.state}/>
            {/*--------------------Полигоны-------------------*/}

            <PropositionSection entity={"polygons"}
                                idKey={`area_id`}
                                label={`Полигоны`}
                                globalChange={this.globalChange.bind(this)}
                                description={this.state.description}
                                onChange={this.checkedHandle.bind(this)}
                                state={this.state}/>
            {/*--------------------Полигоны-------------------*/}

            <PropositionSection entity={"landings"}
                                idKey={`landing_id`}
                                label={`Интроскрины`}
                                globalChange={this.globalChange.bind(this)}
                                description={this.state.description}
                                onChange={this.checkedHandle.bind(this)}
                                state={this.state}/>

            {/*---------------------------------------*/}

            <h2>Заявки <Button colorType={ButtonTypes.positive}
                               onClick={this.confirm.bind(this, true)}
                               disabled={!confirmIsEnabled.length}>
        Подтвердить/Отклонить ({confirmIsEnabled.length})
            </Button>
            </h2>
        </div>;
    }
}

const PropositionSection = ({
    entity,
    globalChange,
    onChange,
    label,
    idKey,
    description,
    state,
}) => {
    return <><h4>
        <Checkbox checked={false}
                  onChange={globalChange.bind(null, entity)} />
        <Link href={`${location.pathname}#/settings/${entity}`}>{label}</Link>
    </h4>
    {
        state[`${entity}IsLoading`] ? <Spin /> : state[`${entity}Error`]
            ? <SimpleError error={state[`${entity}Error`]} />
            : <Table data={state[entity]}
                     report={state[`${entity}_report`]}
                     idKey={idKey}
                     checked={state[`checked_${entity}`]}
                     filters={{
                         description,
                     }}
                     onChange={onChange.bind(null, entity)} />
    }</>;
};
