import { IComponentRequest } from '../../utils/request';

export enum REQUESTS {
    GET_ACTIONS = 'GET_ACTIONS',
    GET_ROLES = 'GET_ROLES',
    GET_POLYGONS = 'GET_POLYGONS',
    GET_LANDINGS = 'GET_LANDINGS',
}

export const CONFIRM_REQUEST: IComponentRequest = {
    [REQUESTS.GET_ACTIONS]: {
        api: 'actions/list',
        cgiObj: {
            report: 'compact',
        },
    },
    [REQUESTS.GET_ROLES]: {
        api: 'roles/list',
        cgiObj: {
            report: 'compact',
        },
    },
    [REQUESTS.GET_POLYGONS]: {
        api: 'areas/info',
    },
    [REQUESTS.GET_LANDINGS]: {
        api: 'landing/get',
    },
};
